package com.cftech.cms.cfarticle.dao;

import com.alibaba.fastjson.JSONObject;
import com.cftech.cms.cfarticle.model.Cfarticle;
import com.cftech.cms.cfarticle.model.CfarticleColumnDto;
import com.cftech.cms.cfarticle.model.CfarticleVO;
import com.cftech.cms.cfarticle.model.columnVO;
import com.cftech.core.generic.GenericDao;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
* CMS文章管理Mapper
*
* @author lisw
* @date: 2017-05-03 10:51
*/
public interface CfarticleMapper extends GenericDao<Cfarticle> {

    /**
     * 分页查询
     *
     * @param params
     * @return
     */
    List<CfarticleColumnDto> fetchSearchByPageTemp(Map<String, Object> params);

    /**
     * 查询总数
     *
     * @return
     */
    int countTemp(Map<String, Object> params);

    /**
     * 根据Id in查询，并根据IN的顺序排序查询
     */
    List<Cfarticle> fetchSearchByPageInOrder(Map<String,Object> params);

    int countReview(Map<String,Object> params);
    Integer updatecom(@Param("id") Long id, @Param("recommended")Long recommended, @Param("whetherBanner")Long whetherBanner);
    /**
     * @Author Licc
     * @Description  药品库推荐数据回填
     * @Date 17:24 2020/10/28
     * @Param
     * @return
     **/
    List<CfarticleVO> recommended(Long id);
    /**
     * @Author Licc
     * @Description  阅读量
     * @Date 18:33 2020/10/28
     * @Param
     * @return
     **/
    Integer reading(@Param("id") Long id,@Param("count") int count);
    /**
     * @Author Licc
     * @Description  阅读量查询
     * @Date 18:33 2020/10/28
     * @Param
     * @return
     **/
    CfarticleVO saveReading(@Param("id") Long id);

    Integer selectcom();

    Integer selectBanner();
    /**
     * @Author Licc
     * @Description  门户列表数据回填
     * @Date 10:50 2020/10/30
     * @Param  
     * @return 
     **/
    List<Cfarticle> gateway(@Param("title") String title);
    /**
     * @Author Licc
     * @Description  栏目列表数据回填
     * @Date 10:50 2020/10/30
     * @Param
     * @return
     **/
   List<columnVO> column();

    /**
     * @Author Licc
     * @Description 栏目文章详情
     * @Date 10:34 2020/10/30
     * @Param
     * @return
     **/
    List<CfarticleVO>  columnDetails(@Param("id") Long id);

}