package com.cftech.addresst.service.impl;

import com.cftech.addresst.model.Address;
import com.cftech.addresst.dao.AddressMapper;
import com.cftech.addresst.model.Area;
import com.cftech.addresst.service.AddressService;
import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.sql.Conds;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.List;

/**
* 收货地址管理ServiceImpl
*
* @author Licc
* @date: 2020-09-29 17:17
*/
@Service("addressService")
public class AddressServiceImpl extends GenericServiceImpl<Address> implements AddressService {

@Autowired
@Qualifier("addressMapper")
private AddressMapper addressMapper;

@Override
public GenericDao<Address> getGenericMapper() {
return addressMapper;
}

    @Override
    public List<Area> listArea() {
        return addressMapper.listArea();
    }
}