package com.cftech.activity.wheel.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.activity.log.model.WheelLog;
import com.cftech.activity.log.service.WheelLogService;
import com.cftech.activity.wheel.model.Wheel;
import com.cftech.activity.wheel.service.WheelService;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.DateFormatUtils;
import com.cftech.questionnaire.core.paper.model.PaperBaseEntity;
import com.cftech.questionnaire.core.paper.model.PaperLog;
import com.cftech.questionnaire.core.paper.service.PaperLogService;
import com.cftech.questionnaire.core.paper.service.PaperService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.HtmlUtils;

import java.util.Date;
import java.util.List;

/**
 * Created by Administrator on 2017/4/26 0026.
 *
 * @author lisw
 *         手机端大转盘接口
 */
@RestController
@RequestMapping("/mobile/auth/wheel")
@Slf4j
public class MobileWheelController {

    @Autowired
    private WheelService wheelService;

    @Autowired
    private WheelLogService wheelLogService;

    @Autowired
    private PaperService paperService;

    @Autowired
    private PaperLogService paperLogService;


    /**
     * 获取大转盘活动详情接口
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/detail/{id}/{openId}", method = {RequestMethod.GET,RequestMethod.POST} ,produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject detail(@PathVariable("id") Long id,@PathVariable("openId") String openId) {

        JSONObject rtnJson = new JSONObject();

        try {
            Wheel wheel = wheelService.fetchById(id);
            wheel.setPrizes(HtmlUtils.htmlUnescape(wheel.getPrizes()));
            Conds conds = new Conds();
            conds.equal("m.open_id",openId);
            conds.equal("wl.activity_id",id);

            if(wheel!=null){
                int count=wheelLogService.count(conds);
                wheel.setPlayCount(count);
                //今天玩的次数
                conds.equal("date(wl.create_time)", DateFormatUtils.getDateFormat(new Date(),"yyyy-MM-dd"));

                int nowCount=wheelLogService.count(conds);
                wheel.setNowPlayCount(nowCount);
            }

            rtnJson.put("errorNo", 0);
            rtnJson.put("data", wheel);

        } catch (Exception e) {
            log.error("获取活动详情出现异常:" + e.getMessage());
            rtnJson.put("errorNo", 1);
        }

        return rtnJson;
    }

    @RequestMapping(value = "/play/{id}/{openId}", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject play(@PathVariable("id") Long id, @PathVariable("openId") String openId,Long meetingId) {
        JSONObject rtnJson = new JSONObject();
        try {
            Conds conds = new Conds();
            conds.equal("activity_type",0);
            conds.equal("activity_id",id);
            conds.equal("del_flag",0);
            Sort sort = new Sort("create_time", OrderType.DESC);
            List<PaperBaseEntity> list = paperService.fetchSearchByPage(conds,sort,0,0);
            if(list!=null && list.size()>0){   //该活动已经绑定问卷
                for(PaperBaseEntity paperBaseEntity : list){
                    Conds condslog = new Conds();
                    condslog.equal("palyer_id",openId);
                    condslog.equal("del_flag",0);
                    condslog.equal("paper_id",paperBaseEntity.getId());
                    Sort sortlog = new Sort("create_time",OrderType.DESC);
                    List<PaperLog> listlog = paperLogService.fetchSearchByPage(condslog,sortlog,0,0);
                    if(listlog==null || listlog.size()==0){  //改玩家没填问卷
                        rtnJson.put("errorNo",6);  //没有填问卷不能玩
                        return rtnJson;
                    }

                }

            }
            Wheel wheel = wheelService.fetchById(id);
            wheel.setPrizes(HtmlUtils.htmlUnescape(wheel.getPrizes()));
            wheel.setMeetingId(meetingId);
            rtnJson = wheelService.play(openId,wheel);
            if(!rtnJson.getString("errorNo").equals("1")){
                WheelLog wheelLog = new WheelLog();
                wheelLog.setDelFlag(false);
                wheelLog.setAccountsId(wheel.getAccountsId());
                wheelLog.setActivityId(wheel.getId());
                wheelLog.setFrom(wheel.getClass().getSimpleName());
                wheelLog.setOpenId(openId);
                wheelLog.setTitle(wheel.getTitle());
                if(meetingId!=null){
                    wheelLog.setDescription(meetingId.toString());
                }
                wheelLogService.save(wheelLog);
            }

        } catch (Exception e) {
            e.printStackTrace();
            rtnJson.put("errorNo",1);
            rtnJson.put("errorMsg","系统异常");
            log.error("玩游戏出现异常:" + e.getMessage());
        }
        return rtnJson;
    }

}
