var explainer = (function () {
    'use strict';
    var Explainer = function (params) {
        var p = this;
        p.params = {
            appid: '',
            id: '',
            accountsId: '',
            cfApp: null,
            devMode: false,
            localStorage: [],
            submitApi: G.baseUri() + '/mobile/auth/appform/appFormSubmit',
            vt: ''
        };
        for (var param in params) {
            p.params[param] = params[param];
        }
        var cfApp = p.params.cfApp;

        if (p.params.devMode) {

        }
        p.pageSize = 10;
        p.pageNo = 0;
        p.channelData = [];
        p.explainerStatus = 1;
        /**
         * 判断app字段
         * @returns 是否app有值
         */
        var validAppField = function () {
            if (!p.params.appid || p.params.appid == '') {
                return false;
            } else {
                return true;
            }
        };

        /**
         * 确认初始化的app 和tokenId 两个值是否都存在
         * 如果不存在则获取一次,获取不到则初始化失败
         * @returns 初始化基础字段是否成功
         */
        var initBaseFields = function () {
            if (!validAppField()) {
                p.params.appid = cfApp.getQueryString('appid');
                p.params.id = cfApp.getQueryString('id');
                p.params.accountsId = cfApp.getQueryString('accountsId');
                p.explainer = cfApp.getQueryString('explainer');
                p.explainerName = cfApp.getQueryString('explainerName');
                var explainerStatus = cfApp.getQueryString("explainerStatus");
                if(explainerStatus && explainerStatus!=null && explainerStatus!=''){
                    p.explainerStatus = explainerStatus;
                }
            }



            //如果获取不到app和tokenId,则直接从传入的CfApp中获取值
            if (!validAppField()) {
                if (p.params.cfApp) {
                    p.params.appid = cfApp.getAppId();
                    //p.params.tokenId = cfApp.getTokenId();
                }
            }
            p.empInfo = cfApp.getMpInfo();
            p.params.accountsId = p.empInfo.accountsId;
            return validAppField();
        };

        /**
         * 初始化组件
         * @returns {boolean}
         */


        p.init = function () {
            var isPageHide = false;
            window.addEventListener('pageshow', function () {
                if (isPageHide) {
                    window.location.reload();
                }
            });
            window.addEventListener('pagehide', function () {
                isPageHide = true;
            });
            if($(".weui-switch").prop("checked")){
                $("#explainer").show()
            }
            if (initBaseFields()) {
                loadData();
                submitData();
                return true;
            } else {
                return false;
            }
            log();
        };

        var log = function () {
            var formdata = {
                openid: p.empInfo.openId,
                module: "展厅申请",
                modulename: '选择品牌大使',
                keyword: '选择品牌大使',
                keywordid: '',
                vt: new Date().getTime(),
                appid: cfApp.getQueryString('appid'),
                url: location.href
            };
            G.ajax(G.devModePost, '/schaeffler/mobile/testAsync/doLOg', formdata, function (retdata) {


            });
        }




        var initDate = function () {
           
        }
        var loadData = function () {
            //点击选择讲解人
            $("#explainer").click(function(){
                 location.href="./explainer_choose.html?appid="+p.params.appid+"&id="+p.explainer;
            })
            if(p.explainer && p.explainer!=null && p.explainer!=''){
                $(".weui-switch").prop("checked",true);
                $("#explainerName").val(p.explainerName);
                $("#explainer").show();
            }

            //是否需要讲解人滑块更换
            $(".weui-switch").change(function(){
                if($(this).prop("checked")){
                    $("#explainer").show()
                }else{
                    $("#explainer").hide()
                }
            })
        }

        var submitData = function(){
            $("#next_step").click(function(){
               var formDataStr = localStorage.getItem("form"+p.params.appid);
                $("#next_step").css("pointer-events","none");
               if(formDataStr && formDataStr!=null && formDataStr!=''){
                   var formData = JSON.parse(formDataStr);
                   if($(".weui-switch").prop("checked") && (!p.explainer || p.explainer==null || p.explainer=='')){
                       $.modal({
                           title: "",
                           text: '请选择品牌大使 Please choose Brand ambassador.',
                           buttons: [
                               { text: "确定OK", onClick: function () {
                                   $("#next_step").css("pointer-events","inherit");
                               } }
                           ]
                       });
                       return;
                   }
                   if($(".weui-switch").prop("checked")){
                       formData.explainer =p.explainer;
                       formData.ename =p.explainerName;
                       formData.explainerStatus = 0;
                   }else{
                       formData.explainerStatus = p.explainerStatus;
                   }
                   console.log(formData.explainerStatus);
                   G.ajax('post', p.params.submitApi, formData, function (retdata) {
                       $("#next_step").css("pointer-events","inherit");
                       if(retdata.errorNo=='0'){
                           //localStorage.removeItem("form"+p.params.appid);
                           $.modal({
                               title: "",
                               text: '您已成功预约展厅。You have successfully booked the showroom!',
                               buttons: [
                                   { text: "确定OK", onClick: function () { WeixinJSBridge.call('closeWindow'); } }
                               ]
                           });
                       }else if(retdata.errorNo=='1'){
                           $.modal({
                               title: "",
                               text: '系统错误，请稍后重试System error',
                               buttons: [
                                   { text: "确定OK", onClick: function () { console.log(1) } }
                               ]
                           });
                       }else if(retdata.errorNo=='2'){
                           $.modal({
                               title: "",
                               text: '展厅该时段已被预约，请重新选择预约时间段。The showroom has been booked for this period, please select a new time.',
                               buttons: [
                                   { text: "确定OK", onClick: function () { console.log(1) } }
                               ]
                           });
                       }
                   })
               }else{
                   $.modal({
                       title: "",
                       text: '请重新填写数据',
                       buttons: [
                           { text: "确定OK", onClick: function () {
                               location.href="./form.html?appid="+p.params.appid;
                           } }
                       ]
                   });
               }
            })
        }


    };

    return Explainer;
})();
