package com.cftech.sys.dao;

import com.cftech.sys.model.Permission;
import com.cftech.sys.model.PermissionExample;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 权限 Dao 接口
 **/
public interface PermissionMapper{
    int countByExample(PermissionExample example);

    int deleteByExample(PermissionExample example);

    int deleteByPrimaryKey(Long id);

    long insert(Permission record);

    long insertSelective(Permission record);

    List<Permission> selectByExample(PermissionExample example);

    Permission selectByPrimaryKey(Long id);

    int updateByExampleSelective(@Param("record") Permission record, @Param("example") PermissionExample example);

    int updateByExample(@Param("record") Permission record, @Param("example") PermissionExample example);

    int updateByPrimaryKeySelective(Permission record);

    int updateByPrimaryKey(Permission record);

    /**
     * 通过角色id 查询角色 拥有的权限
     * 
     * @param roleId
     * @return
     */
    List<Permission> selectPermissionsByRoleId(Long roleId);
    
    List<Permission> getMenuTree();
    
    List<Permission> getMenuTreeExcludeCurrent();
    
    int updateLevelByPrimaryKey(Map permission);
    
    int insertPermission(Permission permission);
    
    int updateLevel(Map permission);
    
    int updatePermissions(Permission permission);
    
    
    List<Permission> getMenuByRoles(@Param("roleids") String roleids);

    List<Permission> getPermissionsByRoles(@Param("roleids") String roleids);

    List<Permission> getAllPermission();
}