package com.cftech.brand.apply.model;

import com.cftech.brand.apply.detail.model.BrandApplyDetail;
import com.cftech.brand.apply.detail.model.BrandApplyDetailVo;
import com.cftech.core.poi.ExportConfig;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 品牌申请Vo
 *
 * @author faye
 * @date 2020/01/14
 */
@Data
public class BrandApplyVo implements Serializable {

    /** 主键id */
    private Long id;

    /**
     * openId
     */
    private String openId;


    /** 编码 */
    private String number;

    /** 姓名 */
    private String name;

    /** 邮箱 */
    private String email;

    /** 成本中心 */
    private String costCenter;

    /** 部门id */
    private Long departmentId;

    /**
     * 部门名称
     */
    private String departmentName;

    /**
     * 直属领导姓名
     */
    private String lineManager;

    /** 直属领导邮箱 */
    private String lineManagerEmail;

    /** 分类id */
    private Long categoryId;

    /**
     * 分类
     */
    private String categoryName;

    /** 需求说明/用途 */
    private String requireSpecify;

    /** 是否制作实物 */
    private String isMaterialObject;


    /** 期望交付日期 */
    private Date deliveryDate;

    /** 其他备注 */
    private String description;

    /**
     *legal entity
     */
    private String legalEntity;

    /**
     *申请分配类别 0 仅设计 1仅制作 2设计和制作
     */
    private String distributionClass;

    /**
     * 设计人员id
     */
    private Long empId;

    /**
     * 设计人员
     */
    private String empName;

    /**
     * 联系人id
     */
    private Long contactEmpId;

    /**
     * 联系人姓名
     */
    private String contactEmpName;

    /**
     * 联系人联系方式
     */
    private String contactInformation;

    /** 供应商Id */
    private Long supplierId;

    /**
     * 供应商姓名
     */
    private String supplierName;

    /** 工时 */
    private Double manHour;
    /**
     * 预估工作量
     */
    private String estimatedWorkload;
    /**
     * 小时费率
     */
    private Double hourlyRate;

    /**
     * 预估内部费用
     */
    private Double estimateInternalCosts;

    /**
     * 预估外部费用
     */
    private Double estimateExternalCosts;

    /** 预估总费用 */
    private Double quotedPrice;

    /**
     * 拟交付日期
     */
    private Date intendedDeliveryDate;

    /** 申请状态 0待接单 1待申请人确认 2待审批 3审批通过 4关闭 5已完成 */
    private String status;

    /** 所属的账号 */
    private Long accountsId;

    /** 删除标识 */
    private boolean delFlag;

    /** 创建时间 */
    private Date createTime;

    /** 更新时间 */
    private Date updateTime;


    /** 创建人 */
    private Long createBy;

    /** 更新人 */
    private Long updateBy;

    /**
     * 关闭订单理由
     */
    private String closeReason;

    /**
     * 实际交付日期
     */
    private Date actualDeliveryDate;

    /**
     * 内部费用
     */
    private Double innerCost;

    /**
     * 外部费用
     */
    private Double outerCost;

    /**
     * 总费用
     */
    private Double totalCost;

    /**
     * 是否推送申请人评分
     */
    private String isScore;

    /*******管理员评分*********/


    /**
     * 设计质量评分
     */
    private String designQuanlityScore;

    /**
     *制作质量评分
     */
    private String makeQuanlityScore;

    /**
     * 意见反馈
     */
    private String managerFeedback;

    /**********管理员评分--end************/

    /*************申请人评分*****************/

    /**
     * 服务评分
     */
    private String serviceScore;

    /**
     * 意见反馈
     */
    private String feedback;

    /*************申请人评分--end*****************/


    /**
     * 审批人
     */
    private String auditId;

    /**
     * 审批人姓名
     */
    private String auditName;

    /**
     * 子项详情
     */
    private List<BrandApplyDetailVo> details;

    /**
     * 管理员备注
     */
    private String managerRemark;

    /**
     * 成品名称
     */
    private String productName;

    /**
     * 成品类型
     */
    private String productFormat;

    /**
     * 成品备注
     */
    private String productLabel;

    /**
     * 文件存储前缀
     */
    private String filePrefix;

    /**
     * 图集
     */
    private List<BrandApplyProduct> brandApplyProducts;

}