package com.cftech.review.model;

import com.cftech.core.poi.ExportConfig;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 评论
 *
 * @author lisw
 * @date: 2017-05-11 10:31
 */
@Data
public class Review implements Serializable {

    /* 主键id */
    private Long id;
    /* 评论模块 */
    @ExportConfig(value = "评论模块", width = 100)
    private String module_type;
    /* 评论实体ID */
    @ExportConfig(value = "评论实体ID", width = 100)
    private Long entity_id;
    /* 评论内容 */
    @ExportConfig(value = "评论内容", width = 100)
    private String content;

    private String openid;//评论人openid
    /* 评论图片 */
    private String images;
    /* 上级评论ID */
    private Long parent_reviewid;
    /* 所属的账号 */
    private Long accountsId;
    /* 删除标识 */
    private boolean delFlag;
    /* 状态 */
    private String status;
    /* 创建时间 */
    private Date createTime;
    /* 更新时间 */
    private Date updateTime;
    /* 备注 */
    private String description;
    /* 创建人 */
    private Long createBy;
    /* 更新人 */
    private Long updateBy;
    /* 是否点赞 */
    private String likes;
    /* 点赞量 */
    private Long fabulous;

    public Review() {
        this.delFlag = false;
        this.status = "0";
    }

}