package org.mp.api.wxstore;


import com.cftech.core.util.OKHttpUtils;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONObject;
import org.mp.api.wxstore.store.Store;

import java.io.IOException;

/**
 * Created by lisw on 2017/7/6 0006.
 */
@Slf4j
public class JwStoreApi {

    //创建门店
    private static String createStoreUrl = "http://api.weixin.qq.com/cgi-bin/poi/addpoi?access_token=";

    //更新门店
    private static String updateStoreUrl="https://api.weixin.qq.com/cgi-bin/poi/updatepoi?access_token=";

    //删除门店
    private static String delStoreUrl = "https://api.weixin.qq.com/cgi-bin/poi/delpoi?access_token=";

    /**
     *
     */
    public static String createStore(String accessToken, Store store){
        String storeUrl = createStoreUrl+accessToken;
        JSONObject objJson = JSONObject.fromObject(store);
        JSONObject businessJson = new JSONObject();
        JSONObject baseInfoJSON = new JSONObject();
        baseInfoJSON.put("base_info",objJson);
        businessJson.put("business",businessJson);
        String rtnJson = null;
        try {
            rtnJson = OKHttpUtils.postJSON(storeUrl,businessJson.toString());
        } catch (IOException e) {
            e.printStackTrace();
        }
        return rtnJson;
    }

    /**
     * 更新门店
     * @param accessToken
     */
    public static String updateStore(String accessToken, Store store){
        String storeUrl = updateStoreUrl+accessToken;
        JSONObject objJson = JSONObject.fromObject(store);
        JSONObject baseInfoJSON = new JSONObject();
        baseInfoJSON.put("base_info",objJson);
        String rtnJson = null;
        try {
            rtnJson = OKHttpUtils.postJSON(storeUrl,baseInfoJSON.toString());
        } catch (IOException e) {
            e.printStackTrace();
        }
        return rtnJson;
    }

    /**
     * 删除门店
     * @param accessToken
     * @param storeId  微信门店id
     */
    public static String delStore(String accessToken, String storeId){
        String storeUrl = delStoreUrl+accessToken;
        JSONObject paramsJSON = new JSONObject();
        paramsJSON.put("poi_id",storeId);
        String rtnJson = null;
        try {
            rtnJson = OKHttpUtils.postJSON(storeUrl,paramsJSON.toString());
        } catch (IOException e) {
            e.printStackTrace();
        }
        return rtnJson;
    }

    public static void main(String[] args) {
        Store store = new Store();
        store.setRecommend("123123123");
        createStore("1111",store);
    }


}
