package org.mp.api.core.handler.impl;

import org.apache.log4j.Logger;
import org.mp.api.core.annotation.ReqType;
import org.mp.api.core.exception.WexinReqException;
import org.mp.api.core.handler.WeiXinReqHandler;
import org.mp.api.core.req.model.DownloadMedia;
import org.mp.api.core.req.model.WeixinReqConfig;
import org.mp.api.core.req.model.WeixinReqParam;
import org.mp.api.core.util.HttpRequestProxy;
import org.mp.api.core.util.WeiXinReqUtil;

import java.util.Map;

public class WeixinReqMediaDownHandler implements WeiXinReqHandler {

	private static Logger logger = Logger.getLogger(WeixinReqMediaDownHandler.class);
	
	@SuppressWarnings("rawtypes")
	public String doRequest(WeixinReqParam weixinReqParam) throws WexinReqException {
		// TODO Auto-generated method stub
		String strReturnInfo = "";
		if(weixinReqParam.getClass().isAnnotationPresent(ReqType.class)){
			DownloadMedia downloadMedia = (DownloadMedia) weixinReqParam;
			ReqType reqType = weixinReqParam.getClass().getAnnotation(ReqType.class);
			WeixinReqConfig objConfig = WeiXinReqUtil.getWeixinReqConfig(reqType.value());
			if(objConfig != null){
				String reqUrl = objConfig.getUrl();
				String filePath = downloadMedia.getFilePath();
				Map parameters = WeiXinReqUtil.getWeixinReqParam(weixinReqParam);
				//parameters.put("accountsId",downloadMedia.getAccountsId());
				parameters.remove("filePathName");
				if(downloadMedia.getCosconfig().getCosType().equals("qcloud")){//等于true的时候上传到腾讯云
					strReturnInfo = HttpRequestProxy.downMadGetQiniu(reqUrl, downloadMedia.getFilePath(),parameters,downloadMedia.getPrefix(),downloadMedia.getCosconfig());
				}

			}
		}else{
			logger.info("没有找到对应的配置信息");
		}
		return strReturnInfo;
	}

}
