package com.cftech.member.model;

import com.cftech.core.poi.ExportConfig;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author lisw
 * @date: 2017-08-24 17:31
 */
@Data
public class MemberOffline implements Serializable {

    /* 主键id */
    private Long id;
    /* 编码 */
    @ExportConfig(value = "编码", width = 100)
    private String number;
    /* 姓名 */
    @ExportConfig(value = "姓名", width = 100)
    private String name;
    /* 手机号 */
    @ExportConfig(value = "手机号", width = 100)
    private String phone;
    /* 头像 */
    @ExportConfig(value = "头像", width = 100)
    private String imageurl;
    /* 身份证 */
    @ExportConfig(value = "身份证", width = 100)
    private String cardid;

    /* 会员卡号 */
    //@ExportConfig(value = "会员卡号", width = 100)
    private String memberId;
    /* 所属的账号 */
    private Long accountsId;
    /* 删除标识 */
    private boolean delFlag;
    /* 状态 */
    private String status;
    /* 创建时间 */
    @ExportConfig(value = "注册时间", width = 100,dateFormat="yyyy-MM-dd HH:mm:ss")
    private Date createTime;
    /* 更新时间 */
    private Date updateTime;
    /* 备注 */
    private String description;
    /* 创建人 */
    private Long createBy;
    /* 更新人 */
    private Long updateBy;

    /*微信openID*/
    @ExportConfig(value = "openId", width = 100)
    private String openId;


    /**
     * 辅助字段
     */
    /*生日*/
    @ExportConfig(value = "生日", width = 100)
    private String birthday;

    /*性别*/
    @ExportConfig(value = "性别", width = 100)
    private String sex;

    /**会员等级*/
    private String level;

    /**地区*/
    private String area;

    /* 其他信息 */
    //@ExportConfig(value = "完善信息", width = 100)
    private String other;

    /**绑定的门店*/
    private String storeid;

    /**
     *注册时从粉丝表取的门店ID
     * */
    private Long fanssStoreId;







    // public void setCardid(String cardid) {
//        if(StringUtils.isNotBlank(cardid)){
//            int sexNumber = 0;
//            String temStr="";
//            if(cardid.length()==18){//二代身份证
//                sexNumber= Integer.valueOf(cardid.substring(cardid.length()-2,cardid.length()-1));
//                temStr = cardid.substring(6, 14);
//                temStr = temStr.substring(0, 4) + "-" + temStr.substring(4, 6) + "-" + temStr.substring(6);
//            }else if(cardid.length()==15){//老式一代身份证
//                sexNumber= Integer.valueOf(cardid.substring(cardid.length()-1));
//                temStr = cardid.substring(6, 12);
//                temStr = "19" + temStr;
//                temStr = temStr.substring(0, 4) + "-" + temStr.substring(4, 6) + "-" + temStr.substring(6);
//            }
//            if(sexNumber%2==0){
//                this.sex="女";
//            }else{
//                this.sex="男";
//            }
//            this.birthday=temStr;
//        }


        //this.cardid = cardid;
   // }



    public MemberOffline() {
        this.delFlag = false;

    }

}