package com.cftech.activity.market.service.impl;

import com.cftech.activity.market.dao.MarketMapper;
import com.cftech.activity.market.model.Market;
import com.cftech.activity.market.model.MarketDto;
import com.cftech.activity.market.service.MarketService;
import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 市场活动ServiceImpl
 *
 * @author faye
 * @date: 2017-08-25 10:36
 */
@Service("marketService")
public class MarketServiceImpl extends GenericServiceImpl<Market> implements MarketService {

    @Autowired
    @Qualifier("marketMapper")
    private MarketMapper marketMapper;

    @Override
    public GenericDao<Market> getGenericMapper() {
        return marketMapper;
    }

    @Override
    public List<MarketDto> fetchSearchByPageVo(Conds conds, Sort sort, int page, int pageSize, String brandid, Long storeid,String openid) {
        Map<String,Object> params=new HashMap<String, Object>();
        params.put("storeid",storeid);
        params.put("brandid",brandid);
        params.put("openid",openid);
        params.put("conds",conds);
        params.put("offset", page > 0 ? page : 0);
        params.put("limit", pageSize > 0 ? pageSize : 0);
        params.put("sort", sort);
        return marketMapper.fetchSearchByPageVo(params);
    }


    @Override
    public int countVo(Conds conds) {
        Map<String,Object> params=new HashMap<String, Object>();
        params.put("conds",conds);
        return marketMapper.countVo(params);
    }

    @Override
    public MarketDto fetchStoreidsAndBrandids(Conds conds) {
        Map<String,Object> params=new HashMap<String, Object>();
        params.put("conds",conds);
        return marketMapper.fetchStoreidsAndBrandids(params);
    }

    @Override
    public List<MarketDto> fetchActByBelong(Conds conds, Sort sort, int page, int pageSize, String openid, String brandid, Long storeid,boolean isAvail,Long memberId) {
        Map<String,Object> params=new HashMap<String, Object>();
        params.put("openid",openid);
        params.put("brandid",brandid);
        if(isAvail){
            params.put("storeStatus","1");
        }
        params.put("storeid",storeid);
        params.put("conds",conds);
        params.put("offset", page > 0 ? page : 0);
        params.put("limit", pageSize > 0 ? pageSize : 0);
        params.put("sort", sort);
        if(memberId!=null){
            params.put("memberId",memberId);
        }
        return marketMapper.fetchActByBelong(params);
    }

    @Override
    public int countActByBelong(Conds conds, String openid, String brandid, Long storeid, boolean isAvail) {
        Map<String,Object> params=new HashMap<String, Object>();
        params.put("openid",openid);
        params.put("brandid",brandid);
        if(isAvail){
            params.put("storeStatus","1");
        }
        params.put("storeid",storeid);
        params.put("conds",conds);
        return marketMapper.countActByBelong(params);
    }

    @Override
    public List<MarketDto> getActListByStore(Conds conds, Sort sort, int page, int pageSize, String openid) {
        Map<String,Object> params=new HashMap<String, Object>();
        params.put("openid",openid);
        params.put("conds",conds);
        params.put("offset", page > 0 ? page : 0);
        params.put("limit", pageSize > 0 ? pageSize : 0);
        params.put("sort", sort);
        return  marketMapper.getActListByStore(params);
    }
}