package com.cftech.collection.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.collection.model.Collection;
import com.cftech.collection.model.CollectionDto;
import com.cftech.collection.service.CollectionService;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.sys.security.AttrValidateUtil;
import com.esotericsoftware.minlog.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;

/**
 * 前端收藏接口
 * Created by mubo 10/11/2017.
 */
@RestController
@RequestMapping("/mobile/auth/collection")
public class MobileCollectionController {

    @Autowired
    private CollectionService collectionService;



    @Autowired
    private RedisTemplate redisTemplate;

    /**
     * 收藏
     * @Param moduleType 编号
     * @Param entityId  被收藏记录id
     * @Param type 0:收藏 2 分享
     * @Param userId
     */
    @RequestMapping(value = "/add", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject like(Collection collection,HttpServletRequest request) {
        //判断参数是否合格
        JSONObject rtnJson = new JSONObject();
        rtnJson.put("errorNo", 1);
        boolean result = AttrValidateUtil.myValidateUtil(collection,"moduleType","entityId","userId");
        if(!result){
            rtnJson.put("errorMsg","参数异常");
            return  rtnJson;
        }
        try {
            //缓存key
            /*String redisCollectionKey = "COLLECTION:" + collection.getAccountsId() + ":" + collection.getModuleType() + ":" + collection.getEntityId();
            if(changeRedisData(redisCollectionKey,1)){*/
            Conds conds=new Conds();
            conds.equal("module_type",collection.getModuleType());
            conds.equal("entity_id",collection.getEntityId());
            conds.equal("user_id",collection.getUserId());
            conds.equal("del_flag",collection.getUserId());
            conds.equal("store_id",collection.getStoreId());
            int count=collectionService.getCollectionCount(conds);
            if(count==0){
                collectionService.saveCollection(collection);
                collectionService.updateexhibiadd(collection);
            }
            rtnJson.put("errorNo",0);
            Log.info("收藏成功"+collection);
        } catch (Exception e) {
            rtnJson.put("errorNo",1);
            rtnJson.put("errorMsg","系统异常");
            e.printStackTrace();
        }
        return rtnJson;
    }
    /**
     * 取消收藏
     * @Param moduleType 编号
     * @Param entityId  被收藏记录id
     * @Param type 1:取消收藏
     * @Param userId
     */
    @RequestMapping(value = "/clearCollection", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject clearLike(Collection collection, HttpServletRequest request) {
        //判断参数是否合格
        JSONObject rtnJson = new JSONObject();
        rtnJson.put("errorNo", 1);
        boolean result = AttrValidateUtil.myValidateUtil(collection,"moduleType","entityId","userId");
        if(!result){
            rtnJson.put("errorMsg","参数异常");
            return  rtnJson;
        }
        try {
            collectionService.clearCollection(collection);
            collectionService.updateexhibiadd(collection);
            rtnJson.put("errorNo",0);
            Log.info("取消收藏成功"+collection);
        } catch (Exception e) {
            rtnJson.put("errorNo",1);
            rtnJson.put("errorMsg","系统异常");
            e.printStackTrace();
        }
        return rtnJson;
    }
    /**
     * 获取收藏数
     * @Param moduleType 编号
     * @Param entityId  被收藏记录id
     * @Param type 1：收藏
     * @Param userId
     * */
    @RequestMapping(value = "/getCollectionCount", method = RequestMethod.GET, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject getLikeCount(Collection collection,String appid,HttpServletRequest request) {
        //判断参数是否合格
        JSONObject rtnJson = new JSONObject();
        rtnJson.put("errorNo", 1);
        boolean result = AttrValidateUtil.myValidateUtil(collection,"moduleType","entityId","type","userId");
        if(!result){
            rtnJson.put("errorMsg","参数异常");
            return  rtnJson;
        }
        Integer saveResult = 0;
        try {
            Conds conds = new Conds();
            conds.equal("module_type",collection.getModuleType());
            conds.equal("entity_id",collection.getEntityId());
            conds.equal("type",collection.getType());
            conds.equal("user_id",collection.getUserId());
            saveResult = collectionService.getCollectionCount(conds);
            rtnJson.put("errorNo",0);
            rtnJson.put("data",saveResult);
        } catch (Exception e) {
            rtnJson.put("errorNo",1);
            rtnJson.put("errorMsg","系统异常");
            e.printStackTrace();
        }
        return rtnJson;
    }
    /**
     * 获取单个收藏
     * @Param moduleType 编号
     * @Param entityId  被收藏记录id
     * @Param type 1：收藏
     * @Param userId
     * */
    @RequestMapping(value = "/getCollectionByAttr", method = RequestMethod.GET, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject getCollectionByAttr(Collection collection,String appid,HttpServletRequest request) {
        //判断参数是否合格
        JSONObject rtnJson = new JSONObject();
        rtnJson.put("errorNo", 1);
        boolean result = false;
        Conds conds = new Conds();
        if(collection.getId() != null){
            conds.equal("t.id",collection.getId());
            result=true;
        }else{
            result = AttrValidateUtil.myValidateUtil(collection,"moduleType","entityId","type","userId");
            conds.equal("module_type",collection.getModuleType());
            conds.equal("entity_id",collection.getEntityId());
            conds.equal("type",collection.getModuleType());
            conds.equal("user_id",collection.getUserId());
        }
        if(!result){
            rtnJson.put("errorMsg","参数异常");
            return  rtnJson;
        }
        try {
            collection = collectionService.fetchSearchByConds(conds);
            rtnJson.put("errorNo",0);
            rtnJson.put("data",collection);
        } catch (Exception e) {
            rtnJson.put("errorNo",1);
            rtnJson.put("errorMsg","系统异常");
            e.printStackTrace();
        }
        return rtnJson;
    }

    @RequestMapping(value = "findCollectionByPageVoList",method = RequestMethod.GET, produces = MediaType.APPLICATION_JSON_UTF8_VALUE )
    public JSONObject findCollectionByPageVoList(Long memberId,String type,int page,int pageSize,String openId){
        JSONObject rtnJson = new JSONObject();
        Conds conds = new Conds();
        conds.equal("c.user_id",memberId);
        conds.equal("c.del_flag",0);
        Sort sort = new Sort("c.create_time",OrderType.DESC);
        List<CollectionDto> collectionDtos = new ArrayList<CollectionDto>();
        try{
            if(type.equals("1")){
                collectionDtos = collectionService.findCollectionByPageVoCar(conds,sort,page*pageSize,pageSize);
            }else if(type.equals("2")){
                collectionDtos = collectionService.findCollectionByPageVoCfarticle(conds,sort,page*pageSize,pageSize);
            }else{
                collectionDtos = collectionService.findCollectionByPageVoActivity(conds,sort,page*pageSize,pageSize,openId);
            }
            rtnJson.put("errorNo",0);
            rtnJson.put("datas",collectionDtos);
        }catch (Exception e){
            e.printStackTrace();
            rtnJson.put("errorNo",1);
        }
        return rtnJson;
    }

    @RequestMapping(value = "isCollection",method = RequestMethod.GET, produces = MediaType.APPLICATION_JSON_UTF8_VALUE )
    public JSONObject isCollection(Long accountsId,String moduleType,Long entityId,Long userId,Long storeId){
        JSONObject rtnJson = new JSONObject();
        Conds conds = new Conds();
        conds.equal("accounts_id",accountsId);
        conds.equal("module_type",moduleType);
        conds.equal("entity_id",entityId);
        conds.equal("user_id",userId);
        conds.equal("del_flag","0");
        if(storeId!=null){
            conds.equal("store_id",storeId);
        }
        Sort sort = new Sort("c.create_time",OrderType.DESC);
        try{
           Collection collection = collectionService.fetchSearchByConds(conds);
            if(collection!=null){
                rtnJson.put("errorNo",0);
            }else{
                rtnJson.put("errorNo",2);
            }
        }catch (Exception e){
            e.printStackTrace();
            rtnJson.put("errorNo",1);
        }
        return rtnJson;
    }



}