package com.cftech.collection.service.impl;

import com.cftech.collection.dao.CollectionMapper;
import com.cftech.collection.model.Collection;
import com.cftech.collection.model.CollectionDto;
import com.cftech.collection.service.CollectionService;
import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * collectionService
 * Created by mubo 11/05/2017.
 */
@Service("collectionService")
public class CollectionServiceImpl extends GenericServiceImpl<Collection> implements CollectionService {

    /**
     * collectionMapper
     */
    @Autowired
    @Qualifier("collectionMapper")
    private CollectionMapper collectionMapper;




    @Override
    public GenericDao<Collection> getGenericMapper() {
        return collectionMapper;
    }

    @Override
    public Boolean saveCollection(Collection collection) {
        //生成收藏记录
        Long saveResult = collectionMapper.save(collection);
        //生成收藏log
//        Long saveLogResult = collectionMapper.saveLog(collection);
//        return saveResult * saveLogResult > 0;
        return saveResult>0;
    }

    @Override
    public Boolean clearCollection(Collection collection) {
        HashMap params = new HashMap();
        Conds conds = new Conds();
        conds.equal("module_type", collection.getModuleType());
        conds.equal("entity_id", collection.getEntityId());
        conds.equal("user_id", collection.getUserId());
        conds.equal("store_id",collection.getStoreId());
        params.put("conds", conds);
        int collectionNo=collectionMapper.getCollectionCount(params);
        if(collectionNo<=0){
            return false;
        }
        //删除收藏记录
        Long deleteResult = collectionMapper.deleteForever(params);
        //生成收藏log
//        Long delLogResult = collectionMapper.deleteLog(params);
//        return deleteResult * delLogResult == 0;
        return deleteResult>0;
    }

    @Override
    public Integer getCollectionCount(Conds conds) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
        return collectionMapper.getCollectionCount(params);
    }

    @Override
    public Integer findCollectionByPageVoCount(Conds conds,String entityName) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
        params.put("entityName", "%"+entityName+"%");
        return collectionMapper.findCollectionByPageVoCount(params);
    }

    @Override
    public List<CollectionDto> findCollectionByPageVo(Conds conds, Sort sort, int iDisplayStart, int iDisplayLength,String entityName,String userName) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
        params.put("entityName", "%"+entityName+"%");
        params.put("userName", "%"+userName+"%");
        params.put("offset", iDisplayStart > 0 ? iDisplayStart : 0);
        params.put("limit", iDisplayLength > 0 ? iDisplayLength : 0);
        params.put("sort", sort);
        return collectionMapper.findCollectionByPageVo(params);
    }

    @Override
    public List<CollectionDto> findCollectionByPageVoCar(Conds conds, Sort sort, int iDisplayStart, int iDisplayLength) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
        params.put("offset", iDisplayStart > 0 ? iDisplayStart : 0);
        params.put("limit", iDisplayLength > 0 ? iDisplayLength : 0);
        params.put("sort", sort);
        return collectionMapper.findCollectionByPageVoCar(params);
    }

    @Override
    public List<CollectionDto> findCollectionByPageVoCfarticle(Conds conds, Sort sort, int iDisplayStart, int iDisplayLength) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
        params.put("offset", iDisplayStart > 0 ? iDisplayStart : 0);
        params.put("limit", iDisplayLength > 0 ? iDisplayLength : 0);
        params.put("sort", sort);
        return collectionMapper.findCollectionByPageVoCfarticle(params);
    }

    @Override
    public List<CollectionDto> findCollectionByPageVoActivity(Conds conds, Sort sort, int iDisplayStart, int iDisplayLength,String openId) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
        params.put("openId", openId);
        params.put("offset", iDisplayStart > 0 ? iDisplayStart : 0);
        params.put("limit", iDisplayLength > 0 ? iDisplayLength : 0);
        params.put("sort", sort);
        return collectionMapper.findCollectionByPageVoActivity(params);
    }

    //收藏一个展会，展会表里面的收藏数加1
    @Override
    public void updateexhibiadd(Collection collection){
        Map param = new HashMap();
        try {
            if(collection.getModuleType().equals("0")){
                param.put("count",1);
                param.put("id",collection.getEntityId());
                collectionMapper.updateexhibi(param);
            }else{
                param.put("count",-1);
                param.put("id",collection.getEntityId());
                collectionMapper.updateexhibi(param);
            }
        }catch (Exception e){
            e.printStackTrace();
        }
    }

}
