package com.cftech.cms.cfarticle.model;

import com.cftech.core.poi.ExportConfig;
import com.cftech.core.util.FileUtils;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;

/**
 * CMS文章管理
 *
 * @author lisw
 * @date: 2017-05-03 10:51
 */
@Data
public class Cfarticle implements Serializable {





    /* 主键id */
    private Long id;
    /* 文章标题 */
    @ExportConfig(value = "文章标题", width = 100)
    private String title;

    /*文章作者*/
    private String author;

    /*阅读全文*/
    private String contentSourceUrl;

    private String type;

    /*作为微信被动回复消息时,图文直接跳转到此链接*/
    private char isUrl;

    /* 文章大图封面 */
    @ExportConfig(value = "文章大图封面", width = 100)
    private String bigimg;
    /* 文章小图封面 */
    @ExportConfig(value = "文章小图封面", width = 100)
    private String smallimg;
    /* 文章内容 */
    @ExportConfig(value = "文章内容", width = 100)
    private String content;
    /* 文章描述 */
    @ExportConfig(value = "文章描述", width = 100)
    private String desc;
    /* 关联的文章 */
    @ExportConfig(value = "关联的文章", width = 100)
    private String relation_article;
    /* 分类名称 */
    @ExportConfig(value = "所属栏目", width = 100)
    private Long column;
    /* 所属的账号 */
    private Long accountsId;
    /* 删除标识 */
    private boolean delFlag;
    /* 状态 */
    private String status;
    /* 创建时间 */
    private Date createTime;
    /* 更新时间 */
    private Date updateTime;
    /* 备注 */
    private String description;
    /* 创建人 */
    private Long createBy;
    /* 更新人 */
    private Long updateBy;
    /*是否置顶文章*/
    private Long recommended;

    /*是否置顶*/
    private Long whetherBanner;
    /* 封面微信ID */
    private String thumbMediaId;

    private  Long reading;

    private  Long article;




    private  Long size;
    public Cfarticle() {
        this.delFlag = false;
        this.status = "0";
        this.isUrl='1';
        this.type="0";
    }
}