package com.cftech.product.service;

import com.alibaba.fastjson.JSONObject;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.product.model.Product;
import com.cftech.core.generic.GenericService;
import com.cftech.product.model.ProductVO;

import java.util.List;

/**
* 产品Service
*
* @author Buyj
* @date: 2020-09-24 15:07
*/
public interface ProductService extends GenericService<Product> {


    /**
     * 商品导入
     * @param product
     */
     boolean saveProduct(Product product);

     /**
      * @Author Licc
      * @Description 根据id查询商品详情
      * @Date 11:08 2020/10/22
      * @Param
      * @return
      **/
     JSONObject productId(Long ID,String appId);

    /**
     * 查询产品列表
     * @param conds
     * @param sort
     * @param pageSize
     * @param pageNo
     * @param classifyId
     * @return
     */
    List<Product> selectProduct(Conds conds, Sort sort,int pageSize,int pageNo,List<String> classifyId);
}
