package com.cftech.core.mybatis.mybatis;




import java.util.Map;

/**
 * Created by lisw on 2016-08-05
 */
public class TableBean {

	/**
	 * tableName
	 */
	private String tableName;

	/**
	 * tableComment
	 */
	private String tableComment;

	/**
	 * 列名数组
	 */
	private String[] columnNames; // 列名数组

	/**
	 * 列名类型数组
	 */
	private String[] columnTypes; // 列名类型数组

	/**
	 * 列名大小数组
	 */
	private int[] columnSizes; // 列名大小数组

	/**
	 * 实体类名
	 */
	private String entityName;

	/**
	 * 实体类包名,带有model 或者是 entity
	 */
	private String packageName;

	/**
	 * 是否需要导入包java.util.*
	 */
	private boolean flagUtil = false;

	/**
	 * 是否需要导入包java.sql.*
	 */
	private boolean flagSql = false;

	/**
	 * 是否需要导入包java.sql.Timestamp
	 */
	private boolean flagTimestamp = false;

	/**
	 * mybatis 相关类的基础包名,即 dao service rest 所在包的包名
	 */
	private String basePackage;

	/**
	 * 自增字段
	 */
	private String autoIncrementColumn;

	/**
	 * comment
	 */
	private Map<String, String> commentMap;

	public String getTableName() {
		return tableName;
	}

	public void setTableName(String tableName) {
		this.tableName = tableName;
	}

	public String getTableComment() {
		return tableComment;
	}

	public void setTableComment(String tableComment) {
		this.tableComment = tableComment;
	}

	public String[] getColumnNames() {
		return columnNames;
	}

	public void setColumnNames(String[] columnNames) {
		this.columnNames = columnNames;
	}

	public String[] getColumnTypes() {
		return columnTypes;
	}

	public void setColumnTypes(String[] columnTypes) {
		this.columnTypes = columnTypes;
	}

	public int[] getColumnSizes() {
		return columnSizes;
	}

	public void setColumnSizes(int[] columnSizes) {
		this.columnSizes = columnSizes;
	}

	public String getEntityName() {
		return entityName;
	}

	public void setEntityName(String entityName) {

		this.entityName = entityName;
	}

	public String getPackageName() {
		return packageName;
	}

	public void setPackageName(String packageName) {
		this.packageName = packageName;
	}

	public boolean isFlagUtil() {
		return flagUtil;
	}

	public void setFlagUtil(boolean flagUtil) {
		this.flagUtil = flagUtil;
	}

	public boolean isFlagSql() {
		return flagSql;
	}

	public void setFlagSql(boolean flagSql) {
		this.flagSql = flagSql;
	}

	public boolean isFlagTimestamp() {
		return flagTimestamp;
	}

	public void setFlagTimestamp(boolean flagTimestamp) {
		this.flagTimestamp = flagTimestamp;
	}

	public String getBasePackage() {
		return basePackage;
	}

	public void setBasePackage(String basePackage) {
		this.basePackage = basePackage;
	}

	public Map<String, String> getCommentMap() {
		return commentMap;
	}

	public void setCommentMap(Map<String, String> commentMap) {
		this.commentMap = commentMap;
	}

	public String getAutoIncrementColumn() {
		return autoIncrementColumn;
	}

	public void setAutoIncrementColumn(String autoIncrementColumn) {
		this.autoIncrementColumn = autoIncrementColumn;
	}

	// public void print() {
	// System.out.println(tableName);
	// List<String> listNames = Arrays.asList(columnNames);
	// List<String> sortedNames = new ArrayList<>();
	// sortedNames.addAll(listNames);
	// Collections.sort(sortedNames);
	// if (StringUtils.isNotBlank(tableName)) {
	// int length = sortedNames.size();
	// for (int i = 0; i < length; i++) {
	// String name = sortedNames.get(i);
	// System.out.print(name);
	// System.out.print("\t");
	// int index = listNames.indexOf(name);
	// System.out.println(columnTypes[index].toLowerCase().toString());
	// }
	// }
	// }
}
