package com.cftech.productclassify.model;

import com.cftech.core.poi.ExportConfig;
import lombok.Data;
import org.apache.cxf.jaxws.handler.types.CString;

import java.io.Serializable;
import java.util.Date;

/**
 * 产品分类
 *
 * @author Buyj
 * @date: 2020-09-22 18:06
 */
@Data
public class Productclassify implements Serializable {

    /* 主键id */
    private Long id;
    /* 分类名称 */
    @ExportConfig(value = "分类名称", width = 100, showLevel = 2)
    private String classifyName;
    /* 分类编码 */
    @ExportConfig(value = "分类编码", width = 100, showLevel = 2)
    private String classifyNumber;
    /* 分类banner图 */
    @ExportConfig(value = "分类banner图", width = 100, showLevel = 1)
    private String classifyImg;
    /* 序号 */
    @ExportConfig(value = "序号", width = 100, showLevel = 2)
    private String sort;
    /* 是否推荐 */
    @ExportConfig(value = "是否推荐(是/否)", width = 200, showLevel = 2)
    private String whetherRecommend;
    /**
     * 父级ID
     */
    private String parentId;
    /**
     * 父级ID 对应的产品分类名称
     */
    @ExportConfig(value = "父级编码(不填默认为第一级)", width = 300, showLevel = 2)
    private String parentName;
    /**
     * 父级编码
     */
    private String parentNumber;
    /* 所属的账号 */
    private Long accountsId;
    /* 删除标识 */
    private boolean delFlag;
    /* 状态 */
    private String status;
    /* 创建时间 */
    private Date createTime;
    /* 更新时间 */
    private Date updateTime;
    /* 备注 */
    private String description;
    /* 创建人 */
    private Long createBy;
    /* 更新人 */
    private Long updateBy;

    public Productclassify() {
        this.delFlag = false;
        this.status = "0";
    }

}