package com.cftech.activity.log.service.impl;

import com.cftech.activity.log.dao.ScracthLogMapper;
import com.cftech.activity.log.model.ScracthLog;
import com.cftech.activity.log.model.ScracthLogDto;
import com.cftech.activity.log.service.ScracthLogService;
import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
* 刮刮卡活动记录表ServiceImpl
*
* @author lisw
* @date: 2017-04-27 14:05
*/
@Service("scracthLogService")
public class ScracthLogServiceImpl extends GenericServiceImpl<ScracthLog> implements ScracthLogService {

@Autowired
@Qualifier("scracthLogMapper")
private ScracthLogMapper scracthLogMapper;

@Override
public GenericDao<ScracthLog> getGenericMapper() {
return scracthLogMapper;
}

    @Override
    public List<ScracthLogDto> fetchSearchByPageDto(Conds conds, Sort sort, int page, int pageSize){
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
        params.put("offset", page > 0 ? page : 0);
        params.put("limit", pageSize > 0 ? pageSize : 0);
        params.put("sort", sort);
        return scracthLogMapper.fetchSearchByPageDto(params);
    }

}