package com.cftech.workshop.details.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.StringUtils;
import com.cftech.workshop.details.model.Details;
import com.cftech.workshop.details.service.DetailsService;
import com.cftech.workshop.meeting.model.Meeting;
import com.cftech.workshop.meeting.service.MeetingService;
import com.cftech.workshop.workshop.model.Workshop;
import com.cftech.workshop.workshop.service.WorkshopService;
import org.mp.api.core.common.JSONHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.HtmlUtils;

import java.util.List;

/**
 * Created by Ago on 2018/7/18.
 */
@RestController
@RequestMapping(value = "/mobile/auth/detailes")
public class MobileDetailsController {

    @Autowired
    private WorkshopService workshopService;

    @Autowired
    private MeetingService meetingService;

    @Autowired
    private DetailsService detailsService;

    /**
     * 查看我的行程
     * @param meetingId 研讨会的ID
     * @return
     */
    @RequestMapping(value = "/getdetails", method = {RequestMethod.GET,RequestMethod.POST}, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject getdetails(Long meetingId,String member_uid){
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("errorNo",0);
            if(StringUtils.isNoneBlank(String.valueOf(meetingId))&&StringUtils.isNoneBlank(member_uid)){
                Meeting meeting = meetingService.fetchById(meetingId);
                if(meeting!=null){
                    jsonObject.put("workshop_title",meeting.getTitle());
                    jsonObject.put("workshop_title_en",meeting.getTitleEn());
                    jsonObject.put("workshop_pic",meeting.getCover());
                    jsonObject.put("workshop_time_start",meeting.getStartTime());
                    jsonObject.put("workshop_time_end",meeting.getEndTime());
                    jsonObject.put("worjshop_address",meeting.getAddress());
                    jsonObject.put("workshop_address_en",meeting.getAddress_en());
                    Conds conds = new Conds();
                    conds.equal("memberUid",member_uid);
                    conds.equal("meeting_id",meetingId);
                    conds.equal("del_flag",0);
                    Sort sort = new Sort("create_time",OrderType.DESC);
                    List<Details> list = detailsService.fetchSearchByPage(conds,sort,0,0);
                    if(list!=null && list.size()>0){
                        for (Details details:list) {
                            jsonObject.put("detailsinfo",HtmlUtils.htmlUnescape(details.getDetailsinfo()));
                        }
                    }
                    jsonObject.put("service",HtmlUtils.htmlUnescape(meeting.getService()));
                }
            }else{
                jsonObject.put("errorNo",2);
            }
        }catch (Exception e){
            e.printStackTrace();
            jsonObject.put("errorNo",1);
        }
        return jsonObject;
    }


}
