package com.cftech.common.grantitems.model;

import com.cftech.core.poi.ExportConfig;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 申请单详情
 *
 * @author faye
 * @date: 2019-08-19 09:45
 */
@Data
public class Grantitems implements Serializable {

    /* 主键id */
    private Long id;
    /* 编码 */
    private String number;

    @ExportConfig(value = "申请单号", width = 100)
    private String formNumber;
    /* 所属申请单 */
    private Long appform;
    /* 所申请商品ID */
    private Long appitem;
    /* 商品名称 */
    @ExportConfig(value = "物品名称", width = 100)
    private String itemname;
    /* 商品单价 */
    @ExportConfig(value = "物品名称", width = 100)
    private String price;
    /* 申请数量 */
    @ExportConfig(value = "申请数量", width = 100)
    private Integer appCount;
    /* 首次发放数量 */
    private Integer grantCount;





    /* 所属的账号 */
    private Long accountsId;
    /* 删除标识 */
    private boolean delFlag;
    /* 状态 */
    private String status;
    /* 创建时间 */
    private Date createTime;
    /* 更新时间 */
    private Date updateTime;
    /* 备注 */
    private String description;
    /* 创建人 */
    private Long createBy;
    /* 更新人 */
    private Long updateBy;

    /*申请规格*/
    @ExportConfig(value = "物品规格", width = 100)
    private String specifications;

    /*剩余库存*/
    private Integer authenticStock;

    /*申请人*/
    @ExportConfig(value = "申请人", width = 100)
    private String name;

    /*申请部门*/
    @ExportConfig(value = "申请部门", width = 100)
    private String departmentName;

    private String typeformName;

    /* 发放数量 */
    @ExportConfig(value = "管理员数量录入时间", width = 100,dateFormat = "yyyy-MM-dd HH:mm")
    private Date grantTime;

    /* 发放数量 */
    @ExportConfig(value = "实际发放数量", width = 100)
    private Integer realityGrantCount;

    @ExportConfig(value = "管理员发货数量", width = 100)
    private Integer managerGrantCount;

    /**
     * 供应商发货数量
     */
    @ExportConfig(value = "供应商发货数量", width = 100)
    private Integer disGrantCount;

    /**
     * 供应商剩余货量
     */
    private Integer disStock;

    /**
     * 管理员录入数量备注
     */
    @ExportConfig(value = "管理员录入数量备注", width = 100)
    private String managerSubmitRemarks;

    /**
     * 管理员发货备注
     */
    @ExportConfig(value = "供应商发货备注", width = 100)
    private String grantRemarks;

    /**
     * 供应商发货备注
     */
    @ExportConfig(value = "管理员录入数量备注", width = 100)
    private String disGrantRemarks;

    /**
     *发货方
     */

    private String grantSource;

    @ExportConfig(value = "发货方", width = 100)
    private String grantSourceName;

    public void setGrantSource(String grantSource) {
        if("0".equals(grantSource)){
            this.grantSourceName="仅供应商";
        }else if("1".equals(grantSource)){
            this.grantSourceName="仅管理员";
        }else if("2".equals(grantSource)){
            this.grantSourceName="供应商+管理员";
        }
        this.grantSource = grantSource;
    }

    /**
     *
     */
    private String cover;

    @ExportConfig(value = "管理员发货时间", width = 100,dateFormat = "yyyy-MM-dd HH:mm")
    private Date managerGrantTime;

    @ExportConfig(value = "供应商发货时间", width = 100,dateFormat = "yyyy-MM-dd HH:mm")
    private Date disGrantTime;

    /**
     * 全部已发货的时间
     */
    private Date deliveryTime;

    private Integer managerAfterStock;//发货后管理员剩余库存

    private Integer disAfterStock; //供应商剩余货量

    public Grantitems() {
        this.delFlag = false;
        this.status = "0";
    }



}
