package com.cftech.mp.article.service.impl;

import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.mp.article.dao.ArticleMapper;
import com.cftech.mp.article.model.MpArticle;
import com.cftech.mp.article.service.ArticleService;
import com.cftech.sys.security.UserUtils;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.mp.api.core.exception.WexinReqException;
import org.mp.api.wxbase.wxmedia.JwMediaAPI;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.Date;

/**
 * 素材管理ServiceImpl
 *
 * @author lisw
 * @date: 2017-04-18 17:37
 */
@Service("articleService")
public class ArticleServiceImpl extends GenericServiceImpl<MpArticle> implements ArticleService {

    @Autowired
    @Qualifier("articleMapper")
    private ArticleMapper articleMapper;

    @Override
    public GenericDao<MpArticle> getGenericMapper() {
        return articleMapper;
    }

    public void saveArticle(JSONArray array, Long accountsId) {
        MpArticle article = new MpArticle();
        for (int i= 0; i<array.size();i++) {
            JSONObject obj = array.getJSONObject(i);
            article.setAccountsId(accountsId);
            article.setCreateBy(UserUtils.getUser().getId());
            article.setUpdateBy(UserUtils.getUser().getId());
            article.setDelFlag(false);
            article.setStatus("0");
            JSONObject objtemp = obj.getJSONObject("content");
            JSONArray arrayTemp = objtemp.getJSONArray("news_item");
            article.setWxUpdateTime(new Date(Long.valueOf(obj.getString("update_time")) * 1000));
            article.setNews_item(arrayTemp.toString());
            article.setMedia_id(obj.getString("media_id"));
            try{
                articleMapper.save(article);
            }catch (Exception e){

                e.printStackTrace();
                e.getMessage();
            }

        }


    }

    @Override
    public Integer updateSynsTable(String accessToken, Long accountsId) {
        articleMapper.truncateTable(accountsId);//清空表
        net.sf.json.JSONObject rtnJson = new net.sf.json.JSONObject();

        JSONObject newsJson = new JSONObject();
        int start = 0;
        int length = 20;
        JSONArray array=null;
        try {
            for (int i = 1; i > 0; i++) {
                newsJson = JwMediaAPI.queryArticlesByMaterial(accessToken, "news", start, length);
                if (newsJson.containsKey("item")) {
                    array = newsJson.getJSONArray("item");

                    if (array.size() < length) {//数量已不足20，没有下一页，结束
                        saveArticle(array, accountsId);
                        break;
                    } else {
                        saveArticle(array, accountsId);
                    }
                    start += length;

                } else {
                    return 0;
                }
            }
        } catch (WexinReqException e) {
            e.printStackTrace();
        }
        return array.size();
    }
}