package com.cftech.cms.exhibi_read.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.base.codingrule.utils.CodingruleUtils;
import com.cftech.cms.exhibi_read.model.Exhibi_read;
import com.cftech.cms.exhibi_read.model.Exhibi_readDto;
import com.cftech.cms.exhibi_read.service.Exhibi_readService;
import com.cftech.core.poi.ExcelKit;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.Constants;
import com.cftech.sys.security.PermissionSign;
import com.cftech.sys.security.UserUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.List;


/**
 * Controller
 * <p>
 * 权限字符串说明:
 * 查看:public static final String EXHIBI_READ_VIEW = "qy:exhibi_read:view"
 * 查看:public static final String EXHIBI_READ_EDIT = "qy:exhibi_read:edit"
 *
 * @author byj
 * @date: 2018-10-10 10:34
 */
@Slf4j
@Controller
@RequestMapping("/a/exhibi_read")
public class Exhibi_readController {

    public static final String EXHIBI_READ_VIEW = "qy:exhibi_read:view";
    public static final String EXHIBI_READ_EDIT = "qy:exhibi_read:edit";

    @Autowired
    private Exhibi_readService exhibi_readService;
    @Autowired
    private CodingruleUtils codingruleUtils;


    //列表页面
    @RequiresPermissions(value = EXHIBI_READ_VIEW)
    @RequestMapping("/list")
    public String list(HttpServletRequest request, Model model,Long id) {
        Long accountId = UserUtils.getmpaccounts(request);
        model.addAttribute("accountId", accountId);
        model.addAttribute("exhibi_id",id);
        return "exhibi_read/exhibi_readlist";
    }

    //编辑页面（新增、修改）
    @RequiresPermissions(value = EXHIBI_READ_VIEW)
    @RequestMapping("/form")
    public String form(HttpServletRequest request, String id, Model model) {
        if (!StringUtils.isEmpty(id)) {
            Exhibi_read exhibi_read = exhibi_readService.fetchById(id);
            model.addAttribute("data", exhibi_read);
        }
        return "exhibi_read/exhibi_readform";
    }

    //提交数据（新增、修改）
    @RequiresPermissions(value = EXHIBI_READ_EDIT)
    @RequestMapping("/formData")
    @ResponseBody
    public JSONObject formData(Exhibi_read exhibi_read, Model model, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        JSONObject rtnJson = new JSONObject();
        try {
            if (exhibi_read != null && exhibi_read.getId() != null) {
                exhibi_read.setUpdateBy(UserUtils.getUser().getId());
                exhibi_readService.update(exhibi_read);
                rtnJson.put("errorNo", 0);
            } else {
                exhibi_read.setNumber(codingruleUtils.getNumber(accountsId, Exhibi_read.class.getName()));
                exhibi_read.setAccountsId(accountsId);
                exhibi_read.setDelFlag(false);
                exhibi_read.setAccountsId(UserUtils.getmpaccounts(request));
                exhibi_read.setCreateBy(UserUtils.getUser().getId());
                exhibi_read.setUpdateBy(UserUtils.getUser().getId());
                exhibi_readService.save(exhibi_read);
                rtnJson.put("errorNo", 2);
            }
        } catch (Exception e) {
            rtnJson.put("errorNo", 1);
        }
        return rtnJson;
    }

    //获取列表数据
    @RequiresPermissions(value = EXHIBI_READ_VIEW)
    @RequestMapping(value = "/listData")
    @ResponseBody
    public JSONObject listData(int iDisplayStart, int iDisplayLength, Exhibi_read exhibi_read, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        Conds conds = new Conds();
        conds.equal("e.del_flag", Constants.DEL_FLAG_0);
        conds.equal("accounts_id", accountsId);
        if(!StringUtils.isEmpty(exhibi_read.getExhibi_id())){
            conds.equal("e.exhibi_id",exhibi_read.getExhibi_id());
        }
        Sort sort = new Sort("e.create_time", OrderType.DESC);

        List<Exhibi_read> list = exhibi_readService.fetchSearchByPage(conds, sort, iDisplayStart, iDisplayLength);
        Integer counts = exhibi_readService.count(conds);
        JSONObject rtnJson = new JSONObject();
        rtnJson.put("iTotalRecords", counts);
        rtnJson.put("iTotalDisplayRecords", counts);
        rtnJson.put("aaData", list);
        return rtnJson;
    }

    //导出
    @RequestMapping("/exportExcel")
    @RequiresPermissions(value =  EXHIBI_READ_VIEW)
    public void exportExcel(HttpServletRequest request, HttpServletResponse response,Exhibi_read exhibi_read) {
        Long accountsId = UserUtils.getmpaccounts(request);
        Conds conds = new Conds();
        conds.equal("e.del_flag", Constants.DEL_FLAG_0);
        conds.equal("accounts_id", accountsId);
        if(!StringUtils.isEmpty(exhibi_read.getExhibi_id())){
            conds.equal("e.exhibi_id",exhibi_read.getExhibi_id());
        }
        Sort sort = new Sort("e.create_time", OrderType.DESC);

        List<Exhibi_read> list = exhibi_readService.fetchSearchByPage(conds, sort, 0, 0);

        // 生成Excel并使用浏览器下载
        ExcelKit.$Export(Exhibi_readDto.class, response).toExcel(list, "展会浏览");
    }

    //删除数据
    @RequiresPermissions(value = EXHIBI_READ_EDIT)
    @RequestMapping("/delete")
    @ResponseBody
    public JSONObject delete(String id) {
        JSONObject rtnJosn = new JSONObject();
        try {
            exhibi_readService.delete(id);
            rtnJosn.put("errorNo", 0);
        } catch (Exception e) {
            rtnJosn.put("errorNo", 1);
        }
        return rtnJosn;
    }

}
