package com.cftech.cms.email_record.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.base.codingrule.utils.CodingruleUtils;
import com.cftech.cms.email_record.model.Email_record;
import com.cftech.cms.email_record.model.Email_recordDto;
import com.cftech.cms.email_record.service.Email_recordService;
import com.cftech.cms.exhibi_material.model.Exhibi_material;
import com.cftech.cms.exhibi_material.service.Exhibi_materialService;
import com.cftech.core.poi.ExcelKit;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.Constants;
import com.cftech.sys.security.PermissionSign;
import com.cftech.sys.security.UserUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.List;


/**
 * Controller
 * <p>
 * 权限字符串说明:
 * 查看:public static final String EMAIL_RECORD_VIEW = "qy:email_record:view"
 * 查看:public static final String EMAIL_RECORD_EDIT = "qy:email_record:edit"
 *
 * @author byj
 * @date: 2019-03-11 14:11
 */
@Slf4j
@Controller
@RequestMapping("/a/email_record")
public class Email_recordController {

    public static final String EMAIL_RECORD_VIEW = "qy:email_record:view";
    public static final String EMAIL_RECORD_EDIT = "qy:email_record:edit";

    @Autowired
    private Email_recordService email_recordService;
    @Autowired
    private CodingruleUtils codingruleUtils;
    @Autowired
    private Exhibi_materialService exhibi_materialService;


    //列表页面
    @RequiresPermissions(value = EMAIL_RECORD_VIEW)
    @RequestMapping("/list")
    public String list(HttpServletRequest request, Model model,String exhibi_id) {
        Long accountId = UserUtils.getmpaccounts(request);
        model.addAttribute("accountId", accountId);
        if(!StringUtils.isEmpty(exhibi_id)){
            model.addAttribute("exhibi_id",exhibi_id);
        }
        return "email_record/email_recordlist";
    }

    //列表页面
    @RequiresPermissions(value = EMAIL_RECORD_VIEW)
    @RequestMapping("/listDetail")
    public String listDetail(HttpServletRequest request, Model model,String id,String exhibi_id) {
        Long accountId = UserUtils.getmpaccounts(request);
        model.addAttribute("accountId", accountId);
        if(!StringUtils.isEmpty(id)){
            model.addAttribute("id",id);
        }
        if(!StringUtils.isEmpty(exhibi_id)){
            model.addAttribute("exhibi_id",exhibi_id);
        }
        return "email_record/email_recordDlist";
    }



    //编辑页面（新增、修改）
    @RequiresPermissions(value = EMAIL_RECORD_VIEW)
    @RequestMapping("/form")
    public String form(HttpServletRequest request, String id, Model model) {
        if (!StringUtils.isEmpty(id)) {
            Email_record email_record = email_recordService.fetchById(id);
            model.addAttribute("data", email_record);
        }
        return "email_record/email_recordform";
    }

    //提交数据（新增、修改）
    @RequiresPermissions(value = EMAIL_RECORD_EDIT)
    @RequestMapping("/formData")
    @ResponseBody
    public JSONObject formData(Email_record email_record, Model model, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        JSONObject rtnJson = new JSONObject();
        try {
            if (email_record != null && email_record.getId() != null) {
                email_record.setUpdateBy(UserUtils.getUser().getId());
                email_recordService.update(email_record);
                rtnJson.put("errorNo", 0);
            } else {
                email_record.setNumber(codingruleUtils.getNumber(accountsId, Email_record.class.getName()));
                email_record.setAccountsId(accountsId);
                email_record.setDelFlag(false);
                email_record.setAccountsId(UserUtils.getmpaccounts(request));
                email_record.setCreateBy(UserUtils.getUser().getId());
                email_record.setUpdateBy(UserUtils.getUser().getId());
                email_recordService.save(email_record);
                rtnJson.put("errorNo", 2);
            }
        } catch (Exception e) {
            rtnJson.put("errorNo", 1);
        }
        return rtnJson;
    }

    //获取列表数据
    @RequiresPermissions(value = EMAIL_RECORD_VIEW)
    @RequestMapping(value = "/listData")
    @ResponseBody
    public JSONObject listData(int iDisplayStart, int iDisplayLength, Email_recordDto email_recordDto, HttpServletRequest request,Long exhibi_id) {
        Long accountsId = UserUtils.getmpaccounts(request);
        Conds conds = new Conds();
        conds.equal("r.del_flag", Constants.DEL_FLAG_0);
        conds.equal("accounts_id", accountsId);
        Sort sort = new Sort("r.create_time", OrderType.DESC);
        if(!StringUtils.isEmpty(exhibi_id)){
            conds.equal("r.exhibi_id",exhibi_id);
        }
        if(!StringUtils.isEmpty(email_recordDto.getNickname())){
            conds.like("f.nickname",email_recordDto.getNickname());
        }
        List<Email_recordDto> list = email_recordService.selectEmailRecord(conds, sort, iDisplayStart, iDisplayLength);
        Integer counts = email_recordService.selectEmailRecordCount(conds);
        JSONObject rtnJson = new JSONObject();
        rtnJson.put("iTotalRecords", counts);
        rtnJson.put("iTotalDisplayRecords", counts);
        rtnJson.put("aaData", list);
        return rtnJson;
    }

    @RequiresPermissions(value = EMAIL_RECORD_VIEW)
    @RequestMapping("/selectDetail")
    @ResponseBody
    public JSONObject selectDetail(int iDisplayStart, int iDisplayLength ,String id,String material_name){
        JSONObject rtnJson = new JSONObject();
        Email_record email_record = email_recordService.fetchById(id);
        if(email_record!=null){
            String sample = email_record.getSample_id();
            String[] str = sample.split(",");
            Conds conds = new Conds();
            conds.in("id",str);
            if(!StringUtils.isEmpty(material_name)){
                conds.like("material_name",material_name);
            }
            Sort sort = new Sort("create_time", OrderType.DESC);
            List<Exhibi_material> list = exhibi_materialService.fetchSearchByPage(conds, sort, iDisplayStart, iDisplayLength);
            Integer counts = exhibi_materialService.count(conds);
            rtnJson.put("iTotalRecords", counts);
            rtnJson.put("iTotalDisplayRecords", counts);
            rtnJson.put("aaData", list);
        }
        return  rtnJson;
    }

    //删除数据
    @RequiresPermissions(value = EMAIL_RECORD_EDIT)
    @RequestMapping("/delete")
    @ResponseBody
    public JSONObject delete(String id) {
        JSONObject rtnJosn = new JSONObject();
        try {
            email_recordService.delete(id);
            rtnJosn.put("errorNo", 0);
        } catch (Exception e) {
            rtnJosn.put("errorNo", 1);
        }
        return rtnJosn;
    }

    public static void main(String[] args) {
        
    }

}
