package com.cftech.order.service;

import com.alibaba.fastjson.JSONObject;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.order.model.*;
import com.cftech.core.generic.GenericService;
import com.qiniu.util.Json;
import org.apache.ibatis.annotations.Param;

import java.io.Serializable;
import java.util.List;

/**
* 订单管理Service
*
* @author Licc
* @date: 2020-10-10 14:20
*/
public interface OrderService extends GenericService<Order> {


    List<Order> fetchSearchBy(Conds conds, Sort sort, int page, int pageSize , String id);

    List<ProductOrder> listProduct();
    OrderFromVO fetchId(Serializable id);
    List<OrderFromVO> fetchProductId(Serializable id);
    Integer updateStatus(Long id);
    JSONObject newlyAdded(String datas, Long accountsId);
    JSONObject deleteAll(Long id);
    /**
     * @Author Licc
     * @Description  根据订单状态查询订单
     * @Date 15:45 2020/10/30
     * @Param  
     * @return 
     **/
    JSONObject confirm(OrderMobileDto orderMobileDto);
    /**
     * @Author Licc
     * @Description  订单数量
     * @Date 19:05 2020/11/3
     * @Param
     * @return
     **/
    JSONObject orderSize(String openId,String appId);

    /**
     * @Author Licc
     * @Description  根据搜索条件查询订单
     * @Date 19:05 2020/11/3
     * @Param
     * @return
     **/
    JSONObject orderList(OrderMobileDto orderMobileDto);

}
