package com.cftech.accounts.service;

import com.alibaba.fastjson.JSONObject;
import com.cftech.accounts.dao.SysJobMapper;
import com.cftech.accounts.model.RamJob;
import com.cftech.accounts.model.SysJob;
import com.cftech.accounts.model.TemplateTransfer;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.Constants;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import redis.clients.jedis.JedisPubSub;

import java.util.Iterator;
import java.util.List;
import java.util.Set;

/**
 * Redis 监听器
 * Created by Jasper Huang on 2018/8/17.
 */
@Service
public class RedisSubPubListener extends JedisPubSub {

    @Autowired
    SysJobMapper sysJobMapper;
    @Autowired
    JobTask jobTask;
    @Autowired
    private JobService jobService;

    public void onMessage(String channel, String message) {
        System.out.println(channel + "=" + message);
        try
        {
            JSONObject object = JSONObject.parseObject(message);
            if("1".equals(object.getString("status")))
            {
                object = object.getJSONObject("data");
                SysJob job = new SysJob();
                job.setStatus("1");
                job.setDelFlag(false);
                job.setCreateBy(1L);
                job.setUpdateBy(1L);
                job.setJobuid(object.getString("uuid"));
                job.setAccountsId(object.getLong("accountsId"));
                job.setJobDesc(object.getString("sendTimeStr"));
                job.setJobName(object.getString("jobname"));
                job.setType(object.getString("type"));
                job.setClazzPath("com.cftech.workshop.template.service.JobDemo2");
                sysJobMapper.save(job);
                jobTask.startJob(job);
                TemplateTransfer templateTransfer = JSONObject.toJavaObject(object, TemplateTransfer.class);
                sysJobMapper.saveTemplate(templateTransfer);
            }else if("0".equals(object.getString("status")))
            {
                object = object.getJSONObject("data");
                SysJob job = new SysJob();
                job.setJobuid(object.getString("uuid"));
                sysJobMapper.deleteTemplate(object.getString("uuid"));
                jobTask.remove(job);
                job.setStatus("0");
                sysJobMapper.updateStatus(job);
            }else if("3".equals(object.getString("status")))
            {
                object = object.getJSONObject("data");
                //查看实际内存中的信息
                Conds conds = new Conds();
                conds.equal("del_flag", Constants.DEL_FLAG_0);
                Set<String> uuids = jobTask.getRAMJOBS();
                Object [] objs = new Object[uuids.size()];
                Iterator<String> itr =uuids.iterator();
                int i=0;
                while(itr.hasNext())
                {
                    objs[i] = itr.next();
                    i++;
                }
                if(uuids.size()==0)
                {
                    objs =  new Object[1];
                    objs[0] = '1';
                }

                conds.in("jobuid",objs);
                Sort sort = new Sort("create_time", OrderType.DESC);
                List<SysJob> list = jobService.fetchSearchByPage(conds, sort, 0, 0);
                Integer userCounts = jobService.count(conds);
                JSONObject rtnJson = new JSONObject();
                rtnJson.put("iTotalRecords", userCounts);
                rtnJson.put("iTotalDisplayRecords", userCounts);
                rtnJson.put("aaData", list);
                //写入到数据库中
                RamJob rj = new RamJob();
                rj.setAccountsId(object.getLong("accountsId"));
                rj.setJobJSON(rtnJson.toJSONString());
                rj.setCreateBy(1L);
                rj.setUpdateBy(1L);
                sysJobMapper.insertRamJob(rj);
            }
        }catch (Exception e)
        {
            e.printStackTrace();
        }



    }
}
