package com.cftech.workshop.takedrive.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.StringUtils;
import com.cftech.workshop.takedrive.model.Takedrive;
import com.cftech.workshop.takedrive.service.TakedriveService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.HtmlUtils;

import java.util.List;

/**
 * 试乘试驾接口
 * Created by Ago on 2018/7/13.
 */
@RestController
@RequestMapping(value = "/mobile/auth/takedrive")
public class MobileTakedriveController {

    @Autowired
    private TakedriveService takedriveService;

    /**
     *  是乘车辆
     * @param meetingId 研讨会ID
     * @param page
     * @param pagesize
     * @return
     */
    @RequestMapping(value = "/gettakedrive", method = {RequestMethod.GET,RequestMethod.POST}, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject gettakedrive(Long meetingId , int page,int pagesize){
        JSONObject jsonObject = new JSONObject();
        try {
            if(meetingId!=0){
                Conds conds = new Conds();
                conds.equal("meetingId",meetingId);
                conds.equal("del_flag",0);
                Sort sort = new Sort("sort", OrderType.ASC);
                List<Takedrive> list = takedriveService.fetchSearchByPage(conds,sort,page*pagesize,pagesize);
                if(list!=null && list.size()>0){
                    jsonObject.put("errorNo",0);
                    jsonObject.put("data",list);
                }
            }
        }catch (Exception e){
            e.printStackTrace();
            jsonObject.put("errorNo",1);
        }
        return  jsonObject;
    }

    /**
     * 试驾详情信息
     * @param id 车架实体ID
     * @return
     */
    @RequestMapping(value = "/gettakedrivedetails",method = {RequestMethod.GET,RequestMethod.POST}, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject gettakedrivedetails(Long id){
        JSONObject jsonObject = new JSONObject();
        try {
            if(StringUtils.isNoneBlank(String.valueOf(id))){
                Takedrive takedrive = takedriveService.fetchById(id);
                if(takedrive!=null){
                    jsonObject.put("errorNo",0);
                    takedrive.setContent_takedrive(HtmlUtils.htmlUnescape(takedrive.getContent_takedrive()));
                    takedrive.setContent_takedrive_en(HtmlUtils.htmlUnescape(takedrive.getContent_takedrive_en()));
                    jsonObject.put("data",takedrive);
                }
            }
        }catch (Exception e){
            e.printStackTrace();
            jsonObject.put("errorNp",1);
        }
        return  jsonObject;
    }
}
