package com.cftech.activity.market.sign.web;

import com.cftech.activity.market.model.MarketDto;
import com.cftech.activity.market.service.MarketService;
import com.cftech.activity.market.sign.model.Sign;
import com.cftech.activity.market.sign.model.SignDto;
import com.cftech.activity.market.sign.service.SignService;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.Constants;
import com.cftech.core.util.StringUtils;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Date;
import java.util.List;

/**
 * Created by faye on 2017/10/12.
 */
@RestController
@RequestMapping(value = "/mobile/auth/market/sign")
@Slf4j
public class MobileSignController {

    @Autowired
    private SignService signService;

    @Autowired
    private MarketService marketService;
    /**
     *获取活动数据
     */
    @RequestMapping(value = "/submit", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public String submit(Sign sign,boolean availStatus) {
        JSONObject rtnJson=new JSONObject();
        try{
            Conds conds = new Conds();
            conds.equal("m.del_flag", Constants.DEL_FLAG_0);
            Date now=new Date();
            sign.setEnrollTime(new Date());
            conds.equal("s.storeid",sign.getStoreid());
            conds.equal("m.id",sign.getActivityid());
            /*conds.lessEqual("m.actstarttime",now);
            conds.greatEqual("m.actendtime",now);*/
            conds.lessEqual("m.signstarttime",now);
            conds.greatEqual("m.signendtime",now);
            conds.equal("s.openid",sign.getOpenid());
            conds.equal("s.del_flag","0");
            List<SignDto> list = signService.fetchSearchByPageVo(conds, null, 0, 1);
            if(list!=null&&list.size()>0){
                rtnJson.put("errorNo","1");
                rtnJson.put("errorMsg","您已参与过活动或活动已经过期!");
                return rtnJson.toString();
            }
            rtnJson.put("errorNo","0");
            sign.setDelFlag(availStatus);
            signService.save(sign);
        }catch (Exception e){
            log.error("活动报名异常："+e.getMessage());
            rtnJson.put("errorNo","1");
            rtnJson.put("errorMsg","服务器异常");
        }
        return rtnJson.toString();
    }

    @RequestMapping(value = "/updateByApply", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public String submit(Long id) {
        JSONObject rtnJson=new JSONObject();
        try{
            rtnJson.put("errorNo","0");
            Sign sign=signService.fetchById(id);
            sign.setDelFlag(false);
            signService.update(sign);
        }catch (Exception e){
            log.error("活动报名异常："+e.getMessage());
            rtnJson.put("errorNo","1");
            rtnJson.put("errorMsg","服务器异常");
        }
        return rtnJson.toString();
    }

    /**
     *获取活动数据
     */
    @RequestMapping(value = "/sign", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public String submit(@RequestParam Long activityid,@RequestParam Long storeid,@RequestParam String openid) {
        JSONObject rtnJson=new JSONObject();
        rtnJson.put("errorNo","0");
        try{
            Conds conds=new Conds();
            conds.equal("storeid",storeid);
            conds.equal("activityid",activityid);
            conds.equal("del_flag","0");
            conds.equal("openid",openid);
            Sign sign=signService.fetchSearchByConds(conds);
            if(sign!=null&&sign.getStatus().equals("0")){
                sign.setSignTime(new Date());
                sign.setStatus("1");
                signService.update(sign);
            }else{
                rtnJson.put("errorNo","1");
                rtnJson.put("errorMsg","您没有报名活动或已经签到!");
            }
        }catch (Exception e){
            log.error("活动报名异常："+e.getMessage());
            rtnJson.put("errorNo","1");
            rtnJson.put("errorMsg","服务器异常");
        }
        return rtnJson.toString();
    }
}
