package com.cftech.workshop.activ.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.StringUtils;
import com.cftech.workshop.activ.model.Activ;
import com.cftech.workshop.activ.model.ActivDto;
import com.cftech.workshop.activ.service.ActivService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * Created by Ago on 2018/7/17.
 */
@RestController
@RequestMapping(value = "/mobile/auth/active")
public class MobileActivController {
    @Autowired
    private ActivService activService;

    /**
     * 现场活动
     * @param meetingId 研讨会ID
     * @param page
     * @param pagesize
     * @param  type  0:活动  1：问卷
     * @return
     */
    @RequestMapping(value = "/getactiv", method = {RequestMethod.GET,RequestMethod.POST}, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject getactiv(Long meetingId,int page,int pagesize,String type){
        JSONObject jsonObject = new JSONObject();
        try {
            if(StringUtils.isNoneBlank(meetingId.toString()) && StringUtils.isNoneBlank(type)){
                if(type.equals("0")){ //活动
                    jsonObject.put("errorNo",0);
                    Conds conds = new Conds();
                    conds.equal("workshop_id",meetingId);
                    conds.notEqual("activ_type",4);
                    conds.equal("ac.del_flag",0);
                    Sort sort = new Sort("sort", OrderType.ASC);
                    List<Activ> activ = activService.fetchSearchByPage(conds,sort,page*pagesize,pagesize);
                    if(activ!=null&&activ.size()>0){
                        jsonObject.put("data",activ);
                    }
                }else if(type.equals("1")){ //问卷
                    jsonObject.put("errorNo",0);
                    Conds conds = new Conds();
                    conds.equal("workshop_id",meetingId);
                    conds.equal("activ_type",4);
                    conds.equal("ac.del_flag",0);
                    Sort sort = new Sort("ac.sort", OrderType.ASC);
                    List<Activ> activ = activService.fetchSearchByPage(conds,sort,page*pagesize,pagesize);
                    if(activ!=null&&activ.size()>0){
                        jsonObject.put("data",activ);
                    }
                }

            }else{
                jsonObject.put("errorNo",2);
            }
        }catch (Exception e){
            e.printStackTrace();
            jsonObject.put("errorNo",1);
        }
        return  jsonObject;
    }

}
