package com.cftech.brand.emp.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.base.codingrule.utils.CodingruleUtils;
import com.cftech.brand.emp.model.BrandEmp;
import com.cftech.brand.emp.service.BrandEmpService;
import com.cftech.core.poi.ExcelKit;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.Constants;
import com.cftech.sys.model.User;
import com.cftech.sys.security.PermissionSign;
import com.cftech.sys.security.UserUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.List;


/**
 * 接单人员Controller
 *
 * 权限字符串说明:
 * 查看:public static final String BRANDEMP_VIEW = "qy:brandEmp:view"
 * 查看:public static final String BRANDEMP_EDIT = "qy:brandEmp:edit"
 *
 * @author faye
 * @date 2020/01/14
 */
@Slf4j
@Controller
@RequestMapping("/a/brandEmp")
public class BrandEmpController {

    public static final String BRANDEMP_VIEW = "qy:brandEmp:view";
    public static final String BRANDEMP_EDIT = "qy:brandEmp:edit";

    @Autowired
    private BrandEmpService brandEmpService;
    @Autowired
    private CodingruleUtils codingruleUtils;


    /**
     * 列表页面
     *
     * @param request
     * @param model
     * @return
     */
    @RequiresPermissions(value = BRANDEMP_VIEW)
    @RequestMapping("/list")
    public String list(HttpServletRequest request, Model model) {
        Long accountId = UserUtils.getmpaccounts(request);
        model.addAttribute("accountId", accountId);
        return "brandEmp/brandEmplist";
    }

    /**
     * 编辑页面（新增、修改）
     *
     * @param request
     * @param id
     * @param model
     * @return
     */
    @RequiresPermissions(value = BRANDEMP_VIEW)
    @RequestMapping("/form")
    public String form(HttpServletRequest request, String id, Model model) {
        if (!StringUtils.isEmpty(id)) {
            BrandEmp brandEmp = brandEmpService.fetchById(id);
            model.addAttribute("data", brandEmp);
        }
        return "brandEmp/brandEmpform";
    }

    /**
     * 提交数据（新增、修改）
     *
     * @param brandEmp
     * @param model
     * @param request
     * @return
     */
    @RequiresPermissions(value = BRANDEMP_EDIT)
    @RequestMapping("/formData")
    @ResponseBody
    public JSONObject formData(BrandEmp brandEmp, Model model, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        JSONObject rtnJson = new JSONObject();
        try {
            brandEmp.setUpdateBy(UserUtils.getUser().getId());
            if (brandEmp != null && brandEmp.getId() != null) {
                brandEmpService.update(brandEmp);
                rtnJson.put("errorNo", 0);
            } else {
                brandEmp.setNumber(codingruleUtils.getNumber(accountsId, BrandEmp.class.getName()));
                brandEmp.setAccountsId(accountsId);
                brandEmp.setDelFlag(false);
                brandEmp.setAccountsId(UserUtils.getmpaccounts(request));
                brandEmp.setCreateBy(UserUtils.getUser().getId());
                brandEmpService.save(brandEmp);
                rtnJson.put("errorNo", 2);
            }
        } catch (Exception e) {
            log.error("保存接单人员异常:"+e.getMessage());
            rtnJson.put("errorNo", 1);
        }
        return rtnJson;
    }

    /**
     * 获取列表数据
     *
     * @param iDisplayStart
     * @param iDisplayLength
     * @param brandEmp
     * @param request
     * @return
     */

    @RequiresPermissions(value = BRANDEMP_VIEW)
    @RequestMapping(value = "/listData")
    @ResponseBody
    public JSONObject listData(int iDisplayStart, int iDisplayLength, BrandEmp brandEmp, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        Conds conds = new Conds();
        conds.equal("del_flag", Constants.DEL_FLAG_0);
        conds.equal("accounts_id", accountsId);
        if (!StringUtils.isEmpty(brandEmp.getNumber())) {
            conds.like("number", brandEmp.getNumber());
        }
        if (!StringUtils.isEmpty(brandEmp.getName())) {
            conds.like("name", brandEmp.getName());
        }

        if (!StringUtils.isEmpty(brandEmp.getContactInformation())) {
            conds.like("contact_information", brandEmp.getContactInformation());
        }

        Sort sort = new Sort("create_time", OrderType.DESC);

        List<BrandEmp> list = brandEmpService.fetchSearchByPage(conds, sort, iDisplayStart, iDisplayLength);
        Integer counts = brandEmpService.count(conds);
        JSONObject rtnJson = new JSONObject();
        rtnJson.put("iTotalRecords", counts);
        rtnJson.put("iTotalDisplayRecords", counts);
        rtnJson.put("aaData", list);
        return rtnJson;
    }

    /**
     * 删除数据
     *
     * @param id
     * @return
     */
    @RequiresPermissions(value = BRANDEMP_EDIT)
    @RequestMapping("/delete")
    @ResponseBody
    public JSONObject delete(String id) {
        JSONObject rtnJosn = new JSONObject();
        try {
            brandEmpService.delete(id);
            rtnJosn.put("errorNo", 0);
        } catch (Exception e) {
            rtnJosn.put("errorNo", 1);
        }
        return rtnJosn;
    }

    /**
     * 导出
     *
     * @param request
     * @param response
     */
    @RequestMapping("/exportExcel")
    @RequiresPermissions(value = BRANDEMP_VIEW)
    public void exportExcel(HttpServletRequest request,BrandEmp brandEmp, HttpServletResponse response) {
        Long accountId = UserUtils.getmpaccounts(request);
        Sort sort = new Sort("create_time", OrderType.ASC);
        Conds conds = new Conds();
        conds.equal("del_flag", 0);
        conds.equal("accounts_id", accountId);
        if (!StringUtils.isEmpty(brandEmp.getNumber())) {
            conds.like("number", brandEmp.getNumber());
        }
        if (!StringUtils.isEmpty(brandEmp.getName())) {
            conds.like("name", brandEmp.getName());
        }

        if (!StringUtils.isEmpty(brandEmp.getContactInformation())) {
            conds.like("contact_information", brandEmp.getContactInformation());
        }
        List<BrandEmp> list = brandEmpService.fetchSearchByPage(conds, sort, 0, 0);
        ExcelKit.$Export(BrandEmp.class, response).toExcel(list, "接单人员信息");
    }

    /**
     * 模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping("/templateExcel")
    @RequiresPermissions(value = BRANDEMP_VIEW)
    public void templateExcel(HttpServletRequest request, HttpServletResponse response) {
        ExcelKit.$Export(BrandEmp.class, response).toExcel(null, "接单人员信息");
    }

    /**
     * 导入
     *
     * @param request
     * @param file
     * @param model
     * @return
     */
    @RequestMapping("/importExcel")
    @RequiresPermissions(value = BRANDEMP_EDIT)
    @ResponseBody
    public JSONObject importExcel(HttpServletRequest request, MultipartFile file, Model model) {
        Long accountId = UserUtils.getmpaccounts(request);
        JSONObject retJson = new JSONObject();
        retJson.put("errorNo", "1");
        if (file == null) {
            retJson.put("errorMsg", "未选择导入文件");
            return retJson;
        }
        // 构造临时路径来存储上传的文件
        String uploadPath = System.getProperty("java.io.tmpdir");
        File uploadDir = new File(uploadPath);
        if (!uploadDir.exists()) {
            uploadDir.mkdir();
        }
        String fileName = file.getOriginalFilename();
        String filePath = uploadPath + File.separator + fileName;
        File storeFile = new File(filePath);
        try {
            file.transferTo(storeFile);
            ExcelKit.$Import().setEmptyCellValue("").readExcel(storeFile, rowData -> {
                BrandEmp brandEmp = new BrandEmp();

                brandEmp.setAccountsId(accountId);
                brandEmp.setName(rowData.get(1));
                brandEmp.setContactInformation(rowData.get(2));
                brandEmp.setEmail(rowData.get(3));
                brandEmp.setUnitPrice(Double.valueOf(rowData.get(4)));
                if (!StringUtils.isEmpty(rowData.get(0))) {
                    brandEmp.setNumber(rowData.get(0));
                    Conds conds=new Conds();
                     conds.equal("del_flag","0");
                     conds.equal("number",brandEmp.getNumber());
                     BrandEmp oldData=brandEmpService.fetchSearchByConds(conds);
                     if(oldData!=null){
                         brandEmp.setId(oldData.getId());
                         brandEmpService.update(brandEmp);
                     }else{
                         brandEmp.setCreateBy(UserUtils.getUser().getId());
                         brandEmpService.save(brandEmp);
                     }
                }else{
                    brandEmp.setNumber(codingruleUtils.getNumber(accountId,BrandEmp.class.getName()));
                    brandEmp.setCreateBy(UserUtils.getUser().getId());
                    brandEmpService.save(brandEmp);
                }
            });
            retJson.put("errorNo", "0");
            retJson.put("errorMsg", "导入成功");
        } catch (Exception e) {
            log.error(e.getMessage());
            retJson.put("errorMsg", "导入失败:" + e.getMessage());
        }

        return retJson;
    }

}
