package com.cftech.base.org.model;

import com.cftech.core.poi.ExportConfig;
import lombok.Data;

import java.io.Serializable;
import java.sql.Timestamp;

/**
 * t_qytag 实体类
 * 企业标签表
 * Created by Neil 14/02/2017.
 */
@Data
public class Qytag implements Serializable {
    /**
     * 企业标签id
     */
    @ExportConfig(value = "企业标签Id", width = 100, showLevel = 1)
    private Long id;

    /**
     * 企业标签名称
     */
    @ExportConfig(value = "企业标签名称", width = 100)
    private String name;

    /**
     * 微信的标签Id
     */
    @ExportConfig(value = "微信标签ID", width = 100, showLevel = 1)
    private String wxtagId;

    /**
     * 所属的账号
     */
    private Long accountsId;

    /**
     * 状态
     */
    private String status;

    /**
     * 创建时间
     */
    private Timestamp createTime;

    /**
     * updateTime
     */
    private Timestamp updateTime;

    /**
     * description
     */
    private String description;

    /**
     * delFlag
     */
    private boolean delFlag;

    /**
     * createBy
     */
    private Long createBy;

    /**
     * updateBy
     */
    private Long updateBy;


    public Qytag() {
        this.delFlag = false;
        this.status = "0";
    }
}