package com.cftech.workshop.feedback.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.base.codingrule.utils.CodingruleUtils;
import com.cftech.workshop.feedback.model.Feedback;
import com.cftech.workshop.feedback.service.FeedbackService;
import com.cftech.core.poi.ExcelKit;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.Constants;
import com.cftech.sys.security.PermissionSign;
import com.cftech.sys.security.UserUtils;
import com.cftech.workshop.workshop.model.Workshop;
import com.cftech.workshop.workshop.model.WorkshopDto;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.List;


/**
 * 意见反馈Controller
 * <p>
 * 权限字符串说明:
 * 查看:public static final String FEEDBACK_VIEW = "qy:feedback:view"
 * 查看:public static final String FEEDBACK_EDIT = "qy:feedback:edit"
 *
 * @author lisw
 * @date: 2019-06-18 15:23
 */
@Slf4j
@Controller
@RequestMapping("/a/feedback")
public class FeedbackController {

    public static final String FEEDBACK_VIEW = "qy:feedback:view";
    public static final String FEEDBACK_EDIT = "qy:feedback:edit";

    @Autowired
    private FeedbackService feedbackService;
    @Autowired
    private CodingruleUtils codingruleUtils;


    //列表页面
    @RequiresPermissions(value = FEEDBACK_VIEW)
    @RequestMapping("/list")
    public String list(HttpServletRequest request, Model model) {
        Long accountId = UserUtils.getmpaccounts(request);
        model.addAttribute("accountId", accountId);
        return "feedback/feedbacklist";
    }

    //编辑页面（新增、修改）
    @RequiresPermissions(value = FEEDBACK_VIEW)
    @RequestMapping("/form")
    public String form(HttpServletRequest request, String id, Model model) {
        if (!StringUtils.isEmpty(id)) {
            Feedback feedback = feedbackService.fetchById(id);
            model.addAttribute("data", feedback);
        }
        return "feedback/feedbackform";
    }

    //提交数据（新增、修改）
    @RequiresPermissions(value = FEEDBACK_EDIT)
    @RequestMapping("/formData")
    @ResponseBody
    public JSONObject formData(Feedback feedback, Model model, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        JSONObject rtnJson = new JSONObject();
        try {
            if (feedback != null && feedback.getId() != null) {
                feedback.setUpdateBy(UserUtils.getUser().getId());
                feedbackService.update(feedback);
                rtnJson.put("errorNo", 0);
            } else {
                feedback.setNumber(codingruleUtils.getNumber(accountsId, Feedback.class.getName()));
                feedback.setAccountsId(accountsId);
                feedback.setDelFlag(false);
                feedback.setAccountsId(UserUtils.getmpaccounts(request));
                feedback.setCreateBy(UserUtils.getUser().getId());
                feedback.setUpdateBy(UserUtils.getUser().getId());
                feedbackService.save(feedback);
                rtnJson.put("errorNo", 2);
            }
        } catch (Exception e) {
            rtnJson.put("errorNo", 1);
        }
        return rtnJson;
    }


    @RequestMapping(value = "/exportData" , method = {RequestMethod.GET,RequestMethod.POST})
    @RequiresPermissions(value = FEEDBACK_VIEW)
    @ResponseBody
    public void exportInviteCodeExcel(HttpServletRequest request, HttpServletResponse response , Feedback feedback) {
        // 生成Excel并使用浏览器下载
        Long accountsId = UserUtils.getmpaccounts(request);
        Conds conds = new Conds();
        conds.equal("del_flag", Constants.DEL_FLAG_0);
        conds.equal("accounts_id", accountsId);
        if (!StringUtils.isEmpty(feedback.getNumber())) {
            conds.like("number", feedback.getNumber());
        }
        if (!StringUtils.isEmpty(feedback.getName())) {
            conds.like("name", feedback.getName());
        }
        if (!StringUtils.isEmpty(feedback.getCompany())) {
            conds.like("commpany", feedback.getCompany());
        }
        if (!StringUtils.isEmpty(feedback.getPhone())) {
            conds.like("phone", feedback.getPhone());
        }
        if (!StringUtils.isEmpty(feedback.getContent())) {
            conds.equal("content", feedback.getContent());
        }
        if (!StringUtils.isEmpty(feedback.getImages())) {
            conds.like("images", feedback.getImages());
        }
        if (!StringUtils.isEmpty(feedback.getImages())) {
            conds.like("images", feedback.getImages());
        }
        if (!StringUtils.isEmpty(feedback.getField1())) {
            conds.like("field1", feedback.getField1());
        }
        if (!StringUtils.isEmpty(feedback.getField2())) {
            conds.like("field2", feedback.getField2());
        }
        if (!StringUtils.isEmpty(feedback.getStatus())) {
            conds.like("status", feedback.getStatus());
        }
        Sort sort = new Sort("create_time", OrderType.DESC);

        List<Feedback> list = feedbackService.fetchSearchByPage(conds, sort, 0, 0);
        ExcelKit.$Export(Feedback.class, response).toExcel(list, "意见反馈列表");
    }

    //获取列表数据
    @RequiresPermissions(value = FEEDBACK_VIEW)
    @RequestMapping(value = "/listData")
    @ResponseBody
    public JSONObject listData(int iDisplayStart, int iDisplayLength, Feedback feedback, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        Conds conds = new Conds();
        conds.equal("del_flag", Constants.DEL_FLAG_0);
        conds.equal("accounts_id", accountsId);
        if (!StringUtils.isEmpty(feedback.getNumber())) {
            conds.like("number", feedback.getNumber());
        }
        if (!StringUtils.isEmpty(feedback.getName())) {
            conds.like("name", feedback.getName());
        }
        if (!StringUtils.isEmpty(feedback.getCompany())) {
            conds.like("commpany", feedback.getCompany());
        }
        if (!StringUtils.isEmpty(feedback.getPhone())) {
            conds.like("phone", feedback.getPhone());
        }
        if (!StringUtils.isEmpty(feedback.getContent())) {
            conds.equal("content", feedback.getContent());
        }
        if (!StringUtils.isEmpty(feedback.getImages())) {
            conds.like("images", feedback.getImages());
        }
        if (!StringUtils.isEmpty(feedback.getImages())) {
            conds.like("images", feedback.getImages());
        }
        if (!StringUtils.isEmpty(feedback.getField1())) {
            conds.like("field1", feedback.getField1());
        }
        if (!StringUtils.isEmpty(feedback.getField2())) {
            conds.like("field2", feedback.getField2());
        }
        if (!StringUtils.isEmpty(feedback.getStatus())) {
            conds.like("status", feedback.getStatus());
        }
        Sort sort = new Sort("create_time", OrderType.DESC);

        List<Feedback> list = feedbackService.fetchSearchByPage(conds, sort, iDisplayStart, iDisplayLength);
        Integer counts = feedbackService.count(conds);
        JSONObject rtnJson = new JSONObject();
        rtnJson.put("iTotalRecords", counts);
        rtnJson.put("iTotalDisplayRecords", counts);
        rtnJson.put("aaData", list);
        return rtnJson;
    }

    //删除数据
    @RequiresPermissions(value = FEEDBACK_EDIT)
    @RequestMapping("/delete")
    @ResponseBody
    public JSONObject delete(String id) {
        JSONObject rtnJosn = new JSONObject();
        try {
            feedbackService.delete(id);
            rtnJosn.put("errorNo", 0);
        } catch (Exception e) {
            rtnJosn.put("errorNo", 1);
        }
        return rtnJosn;
    }

    //更改状态
    @RequiresPermissions(value = FEEDBACK_EDIT)
    @RequestMapping("updateStatus")
    @ResponseBody
    public JSONObject updateStatus(Feedback feedback){
        JSONObject rtnJson = new JSONObject();
        try{
            rtnJson.put("errorNo",0);
            feedback.setStatus("1");
            feedbackService.update(feedback);
        }catch (Exception e){
            e.printStackTrace();
            rtnJson.put("errorNo",1);
        }
        return rtnJson;
    }

}
