package com.cftech.sys.service.impl;

import com.cftech.sys.dao.PermissionMapper;
import com.cftech.sys.model.Permission;
import com.cftech.sys.service.PermissionService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * @author lisw
 * @date 2016年9月20日 下午1:57:40
 *
 */
@Service
public class PermissionServiceImpl  implements PermissionService {

    @Resource
    private PermissionMapper permissionMapper;


    @Override
    public List<Permission> selectPermissionsByRoleId(Long roleId) {
        return permissionMapper.selectPermissionsByRoleId(roleId);
    }

	@Override
	public List<Permission> getMenuTree() {
		return permissionMapper.getMenuTree();
	}

	@Override
	public List<Permission> getMenuTreeExcludeCurrent() {
		return permissionMapper.getMenuTreeExcludeCurrent();
	}

	@Override
	public int updateLevelByPrimaryKey(Map permission) {
		return permissionMapper.updateLevelByPrimaryKey(permission);
	}

	@Override
	public long insertPermission(Permission permission) {
		long primaryKey = permissionMapper.insert(permission);
		//执行更新 
		Map<String,Object> map = new HashMap<String,Object>();
		map.put("id", permission.getId());
		map.put("longnum",permission.getLongnum()+permission.getId()+",");
		permissionMapper.updateLevel(map);
		return primaryKey;
	}

	@Override
	public int updatePermissions(Permission permission) {
			return permissionMapper.updatePermissions(permission);
	}
	
	@Override
	public List<Permission> getMenuByRoles(String roleIds)
	{
		return permissionMapper.getMenuByRoles(roleIds);
	}

	@Override
	public List<Permission> getPermissionsByRoles(String roleIds) {
		return permissionMapper.getPermissionsByRoles(roleIds);
	}

	@Override
	public List<Permission> getAllPermission() {
		return  permissionMapper.getAllPermission();
	}


	@Override
	public int deleteByPrimaryKey(Long id) {
		return permissionMapper.deleteByPrimaryKey(id);
	}

	@Override
	public Permission selectByPrimaryKey(Long id) {
		return permissionMapper.selectByPrimaryKey(id);
	}
}
