package com.cftech.common.marketing.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.common.marketing.model.Marketing;
import com.cftech.common.marketing.service.MarketingService;
import com.cftech.core.poi.ExcelKit;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.Constants;
import com.cftech.sys.security.PermissionSign;
import com.cftech.sys.security.UserUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.List;


/**
 * 市场部领导配置Controller
 * <p>
 * 权限字符串说明:
 * 查看:public static final String MARKETING_VIEW = "qy:marketing:view"
 * 查看:public static final String MARKETING_EDIT = "qy:marketing:edit"
 *
 * @author faye
 * @date: 2019-08-14 17:24
 */
@Slf4j
@Controller
@RequestMapping("/a/marketing")
public class MarketingController {

    public static final String MARKETING_VIEW = "qy:marketing:view";
    public static final String MARKETING_EDIT = "qy:marketing:edit";

    @Autowired
    private MarketingService marketingService;


    //列表页面
    @RequiresPermissions(value = MARKETING_VIEW)
    @RequestMapping("/list")
    public String list(HttpServletRequest request, Model model) {
        Long accountId = UserUtils.getmpaccounts(request);
        model.addAttribute("accountId", accountId);
        return "marketing/marketinglist";
    }

    //编辑页面（新增、修改）
    @RequiresPermissions(value = MARKETING_EDIT)
    @RequestMapping("/form")
    public String form(HttpServletRequest request, String id, Model model,String typeform) {
        Conds conds = new Conds();
        conds.equal("del_flag", 0);
        Marketing marketing = marketingService.fetchSearchByConds(conds);
        model.addAttribute("data", marketing);
        if(StringUtils.isEmpty(typeform)){
            typeform="1";
        }
        model.addAttribute("typeform",typeform);
        return "marketing/marketingform";
    }

    //提交数据（新增、修改）
    @RequiresPermissions(value = MARKETING_EDIT)
    @RequestMapping("/formData")
    @ResponseBody
    public JSONObject formData(Marketing marketing, Model model, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        JSONObject rtnJson = new JSONObject();
        try {
            if (marketing != null && marketing.getId() != null) {
                marketing.setUpdateBy(UserUtils.getUser().getId());
                marketingService.update(marketing);
                rtnJson.put("errorNo", 0);
            } else {
                marketing.setAccountsId(accountsId);
                marketing.setDelFlag(false);
                marketing.setAccountsId(UserUtils.getmpaccounts(request));
                marketing.setCreateBy(UserUtils.getUser().getId());
                marketing.setUpdateBy(UserUtils.getUser().getId());
                marketingService.save(marketing);
                rtnJson.put("errorNo", 2);
            }
        } catch (Exception e) {
            rtnJson.put("errorNo", 1);
        }
        return rtnJson;
    }

    //获取列表数据
    @RequiresPermissions(value = MARKETING_VIEW)
    @RequestMapping(value = "/listData")
    @ResponseBody
    public JSONObject listData(int iDisplayStart, int iDisplayLength, Marketing marketing, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        Conds conds = new Conds();
        conds.equal("del_flag", Constants.DEL_FLAG_0);
        conds.equal("accounts_id", accountsId);
        Sort sort = new Sort("create_time", OrderType.DESC);

        List<Marketing> list = marketingService.fetchSearchByPage(conds, sort, iDisplayStart, iDisplayLength);
        Integer counts = marketingService.count(conds);
        JSONObject rtnJson = new JSONObject();
        rtnJson.put("iTotalRecords", counts);
        rtnJson.put("iTotalDisplayRecords", counts);
        rtnJson.put("aaData", list);
        return rtnJson;
    }

    //删除数据
    @RequiresPermissions(value = MARKETING_EDIT)
    @RequestMapping("/delete")
    @ResponseBody
    public JSONObject delete(String id) {
        JSONObject rtnJosn = new JSONObject();
        try {
            marketingService.delete(id);
            rtnJosn.put("errorNo", 0);
        } catch (Exception e) {
            rtnJosn.put("errorNo", 1);
        }
        return rtnJosn;
    }

    @RequestMapping("/exportExcel")
    @RequiresPermissions(value = MARKETING_VIEW)
    public void exportExcel(HttpServletRequest request, HttpServletResponse response) {
        Long accountId = UserUtils.getmpaccounts(request);
        Sort sort = new Sort("create_time", OrderType.ASC);
        Conds conds = new Conds();
        conds.equal("del_flag", 0);
        conds.equal("accounts_id", accountId);
        List<Marketing> list = marketingService.fetchSearchByPage(conds, sort, 0, 0);
        ExcelKit.$Export(Marketing.class, response).toExcel(list, "市场部领导配置信息");
    }

    @RequestMapping("/templateExcel")
    @RequiresPermissions(value = MARKETING_VIEW)
    public void templateExcel(HttpServletRequest request, HttpServletResponse response) {
        ExcelKit.$Export(Marketing.class, response).toExcel(null, "市场部领导配置信息");
    }

    @RequestMapping("/importExcel")
    @RequiresPermissions(value = MARKETING_EDIT)
    public String importExcel(HttpServletRequest request, MultipartFile file, Model model) {
        Long accountId = UserUtils.getmpaccounts(request);
        if (file == null) {
            return list(request, model);
        }
// 构造临时路径来存储上传的文件
        String uploadPath = System.getProperty("java.io.tmpdir");
        File uploadDir = new File(uploadPath);
        if (!uploadDir.exists()) {
            uploadDir.mkdir();
        }
        String fileName = file.getOriginalFilename();
        String filePath = uploadPath + File.separator + fileName;
        File storeFile = new File(filePath);
        try {
            file.transferTo(storeFile);
            ExcelKit.$Import().readExcel(storeFile, rowData -> {
                if (!StringUtils.isEmpty(rowData.get(0))) {
                    Marketing marketing = new Marketing();
                    marketing.setAccountsId(accountId);

                    marketing.setEmail(rowData.get(0));


                    marketing.setName(rowData.get(1));

                    marketingService.save(marketing);
                }
            });
        } catch (IOException e) {
            log.error(e.getMessage());
        }

        return list(request, model);
    }

}
