package org.mp.api.coupon.qrcode;

import net.sf.json.JSONObject;
import org.mp.api.core.exception.WexinReqException;
import org.mp.api.core.req.WeiXinReqService;
import org.mp.api.coupon.qrcode.model.*;


/**
 * 微信卡券 - 卡券投放
 * @author lihongxuan
 *
 */
public class JwQrcodeAPI {

	/**
	 * 创建二维码
	 * @throws WexinReqException 
	 */
	public static QrcodeRtnInfo doAddQrcode(String accesstoken,QrcodeInfo qrcodeInfo) throws WexinReqException {
		if (accesstoken != null) {
			qrcodeInfo.setAccess_token(accesstoken);
			JSONObject result = WeiXinReqService.getInstance().doWeinxinReqJson(qrcodeInfo);
			QrcodeRtnInfo qrcodeRtnInfo = (QrcodeRtnInfo)JSONObject.toBean(result, QrcodeRtnInfo.class);
			return qrcodeRtnInfo;
		}
		return null;
	}

	/**
	 * 获取api_ticket
	 */
	public static GetticketRtn doGetticket(String accesstoken)throws WexinReqException {
		if (accesstoken != null) {
			Getticket gk = new Getticket();
			gk.setAccess_token(accesstoken);
			JSONObject result = WeiXinReqService.getInstance().doWeinxinReqJson(gk);
			GetticketRtn getticketRtn = (GetticketRtn)JSONObject.toBean(result, GetticketRtn.class);
			return getticketRtn;
		}
		return null;
	}
	
	public static void main(String[] args) throws WexinReqException {
		String token = "7vXKSSxfBicQFWle7ieNirTE0CK7QaYrZ2xQ_J3bC1c-D5DZU1LSwNUXVsfNIP_ZY-f0AICDNlBH2cuE96LT-6lnM7wBuiwdSJ3UJoH30ax1x-hyWQSsSiWrGiKmuLUvEOJhAHAXHC";
		QrcodeInfo qrCode = new QrcodeInfo();
		qrCode.setAction_name("QR_CARD");
		ActionInfo actionInfo = new ActionInfo();
		Card card = new Card();
		card.setCard_id("pW0WhwRgCxwLbY9UgGb6LAzj5LD0");
		card.setIs_unique_code(true);
		card.setOuter_id(123L);
		actionInfo.setCard(card);
		qrCode.setAction_info(actionInfo);
		qrCode.setAccess_token(token);
		JwQrcodeAPI.doAddQrcode(token, qrCode);
	}
}
 