package com.cftech.consultsheet.model;

import com.cftech.core.poi.ExportConfig;
import lombok.Data;

import java.util.Date;

/**
 * @author ：licc
 * @date ：Created in 2020/9/23 20:56
 * @description：
 */
@Data
public class ConsultSheetVO {
    
    /* 咨询单编码 */
    @ExportConfig(value = "咨询单编码", width = 100, showLevel = 1)
    private String consultId;

    @ExportConfig(value = "订单编号" , width = 100, showLevel = 1)
    private String orderCode;

    /* 用药人name */
    @ExportConfig(value = "用药人姓名", width = 100, showLevel = 1)
    private String userName;

    /* 性别 */
    @ExportConfig(value = "性别", width = 100, showLevel = 1)
    private String  sex;

    /* 手机号 */
    @ExportConfig(value = "联系电话", width = 100, showLevel = 1)
    private String phone;

    /* 疾病史 */
    @ExportConfig(value = "有无不良反应", width = 100, showLevel = 1)
    private String pastRecords;

    /* 病情描述 */
    @ExportConfig(value = "是否服用过该药且无禁忌症", width = 100, showLevel = 1)
    private String illness;

    /* 过敏史 */
    @ExportConfig(value = "有无过敏反应", width = 100, showLevel = 1)
    private String allergy;

    /* 状态 */
    @ExportConfig(value = "是否审核", width = 100, showLevel = 1)
    private String status;

    /* 药师姓名*/
    @ExportConfig(value = "药师姓名", width = 100, showLevel = 1)
    private  String pharmaName;

    /* 客服姓名*/
    @ExportConfig(value = "客服姓名", width = 100, showLevel = 1)
    private  String customerName;

    @ExportConfig(value = "拒绝原因" , width = 100 , showLevel = 1)
    private String description;

    @ExportConfig(value = "提交时间" , width = 100, showLevel = 1)
    private String createTime;

    @ExportConfig(value = "审核时间" , width = 100, showLevel = 1)
    private String auditTime;


}
