package com.cftech.activity.log.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.activity.log.model.GiftboxLog;
import com.cftech.activity.log.model.GiftboxLogDto;
import com.cftech.activity.log.service.GiftboxLogService;
import com.cftech.core.poi.ExcelKit;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.Constants;
import com.cftech.sys.security.UserUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;


/**
 * 刮刮卡活动记录表Controller
 * <p>
 * 权限字符串说明:
 * 查看:public static final String GIFTBOXLOG_VIEW = "mp:giftboxLog:view"
 * 查看:public static final String GIFTBOXLOG_EDIT = "mp:giftboxLog:edit"
 *
 * @author lisw
 * @date: 2017-04-27 14:05
 */
@Slf4j
@Controller
@RequestMapping("/a/giftboxLog")
public class GiftboxLogController {

    public static final String GIFTBOXLOG_VIEW = "mp:giftboxLog:view";
    public static final String GIFTBOXLOG_EDIT = "mp:giftboxLog:edit";

    @Autowired
    private GiftboxLogService giftboxLogService;


    //列表页面
    @RequiresPermissions(value = GIFTBOXLOG_VIEW)
    @RequestMapping(value = "/list",method = {RequestMethod.GET,RequestMethod.POST})
    public String list(HttpServletRequest request, Model model) {
        Long accountId = UserUtils.getmpaccounts(request);
        model.addAttribute("accountId", accountId);
        return "giftboxLog/giftboxLoglist";
    }

    //编辑页面（新增、修改）
    @RequiresPermissions(value = GIFTBOXLOG_VIEW)
    @RequestMapping(value = "/form",method = {RequestMethod.GET,RequestMethod.POST})
    public String form(HttpServletRequest request, String id, Model model) {
        if (!StringUtils.isEmpty(id)) {
            GiftboxLog giftboxLog = giftboxLogService.fetchById(id);
            model.addAttribute("data", giftboxLog);
        }
        return "giftboxLog/giftboxLogform";
    }

    //提交数据（新增、修改）
    @RequiresPermissions(value = GIFTBOXLOG_EDIT)
    @RequestMapping(value = "/formData"
            ,method = {RequestMethod.POST})
    @ResponseBody
    public JSONObject formData(GiftboxLog giftboxLog, Model model, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        JSONObject rtnJson = new JSONObject();
        try {
            if (giftboxLog != null && giftboxLog.getId() != null) {
                giftboxLog.setUpdateBy(UserUtils.getUser().getId());
                giftboxLogService.update(giftboxLog);
                rtnJson.put("errorNo", 0);
            } else {
                giftboxLog.setAccountsId(accountsId);
                giftboxLog.setDelFlag(false);
                giftboxLog.setAccountsId(UserUtils.getmpaccounts(request));
                giftboxLog.setCreateBy(UserUtils.getUser().getId());
                giftboxLog.setUpdateBy(UserUtils.getUser().getId());
                giftboxLogService.save(giftboxLog);
                rtnJson.put("errorNo", 2);
            }
        } catch (Exception e) {
            rtnJson.put("errorNo", 1);
        }
        return rtnJson;
    }

    //获取列表数据
    @RequiresPermissions(value = GIFTBOXLOG_VIEW)
    @RequestMapping(value = "/listData",method = {RequestMethod.GET,RequestMethod.POST})
    @ResponseBody
    public JSONObject listData(int iDisplayStart, int iDisplayLength, GiftboxLogDto giftboxLogDto, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        Conds conds = new Conds();
        conds.equal("g.del_flag", Constants.DEL_FLAG_0);
        conds.equal("gl.accounts_id", accountsId);
        if (!StringUtils.isEmpty(giftboxLogDto.getTitle())) {
            conds.like("gl.title", giftboxLogDto.getTitle());
        }
        if (!StringUtils.isEmpty(giftboxLogDto.getName())) {
            conds.like("m.name",giftboxLogDto.getName());
        }


        Sort sort = new Sort("gl.create_time", OrderType.DESC);

        List<GiftboxLogDto> list = giftboxLogService.fetchSearchByPageDto(conds, sort, iDisplayStart, iDisplayLength);
        Integer counts = giftboxLogService.count(conds);
        JSONObject rtnJson = new JSONObject();
        rtnJson.put("iTotalRecords", counts);
        rtnJson.put("iTotalDisplayRecords", counts);
        rtnJson.put("aaData", list);
        return rtnJson;
    }

    //删除数据
    @RequiresPermissions(value = GIFTBOXLOG_EDIT)
    @RequestMapping(value = "/delete",method = {RequestMethod.POST})
    @ResponseBody
    public JSONObject delete(String id) {
        JSONObject rtnJosn = new JSONObject();
        try {
            giftboxLogService.delete(id);
            rtnJosn.put("errorNo", 0);
        } catch (Exception e) {
            rtnJosn.put("errorNo", 1);
        }
        return rtnJosn;
    }

    @RequiresPermissions(value = GIFTBOXLOG_EDIT)
    @RequestMapping(value = "/exportExcel",method = RequestMethod.GET)
    public void exportExcel(HttpServletRequest request, HttpServletResponse response, GiftboxLogDto giftboxLogDto){
        Long accountsId = UserUtils.getmpaccounts(request);
        Conds conds = new Conds();
        conds.equal("g.del_flag", Constants.DEL_FLAG_0);
        conds.equal("gl.accounts_id", accountsId);
        if (!StringUtils.isEmpty(giftboxLogDto.getTitle())) {
            conds.like("gl.title", giftboxLogDto.getTitle());
        }
        if (!StringUtils.isEmpty(giftboxLogDto.getName())) {
            conds.like("m.name",giftboxLogDto.getName());
        }


        Sort sort = new Sort("gl.create_time", OrderType.DESC);

        List<GiftboxLogDto> list = giftboxLogService.fetchSearchByPageDto(conds, sort, 0, 0);
//        if(list!=null && list.size()>0){
//            for (WheelLogDto wheelLogDto1 : list){
//                if(wheelLogDto1.getCreate_time()!=null)
//                    wheelLogDto1.setCreate_time_str(DateFormatUtils.getDateFormat(wheelLogDto1.getCreate_time(),"yyyy-MM-dd HH:mm" ));
//            }
//        }
        // 生成Excel并使用浏览器下载
        ExcelKit.$Export(GiftboxLogDto.class, response).toExcel(list, "拆礼盒参与人员信息");
    }

}
