package com.cftech.workshop.takedrive.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.base.codingrule.utils.CodingruleUtils;
import com.cftech.workshop.meeting.service.MeetingService;
import com.cftech.workshop.takedrive.model.Takedrive;
import com.cftech.workshop.takedrive.service.TakedriveService;
import com.cftech.core.poi.ExcelKit;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.Constants;
import com.cftech.sys.security.PermissionSign;
import com.cftech.sys.security.UserUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.owasp.esapi.ESAPI;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.util.HtmlUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.List;


/**
 * Controller
 * <p>
 * 权限字符串说明:
 * 查看:public static final String TAKEDRIVE_VIEW = "qy:takedrive:view"
 * 查看:public static final String TAKEDRIVE_EDIT = "qy:takedrive:edit"
 *
 * @author byj
 * @date: 2018-07-10 16:21
 */
@Slf4j
@Controller
@RequestMapping("/a/takedrive")
public class TakedriveController {

    public static final String TAKEDRIVE_VIEW = "qy:takedrive:view";
    public static final String TAKEDRIVE_EDIT = "qy:takedrive:edit";

    @Autowired
    private TakedriveService takedriveService;
    @Autowired
    private CodingruleUtils codingruleUtils;

    @Autowired
    private MeetingService meetingService;


    //列表页面
    @RequiresPermissions(value = TAKEDRIVE_VIEW)
    @RequestMapping(value = "/list", method = {RequestMethod.POST,RequestMethod.GET})
    public String list(HttpServletRequest request, Model model,String meetingId) {
        Long accountId = UserUtils.getmpaccounts(request);
        model.addAttribute("accountId", accountId);
        model.addAttribute("meetingId", meetingId);
        return "takedrive/takedrivelist";
    }

    //编辑页面（新增、修改）
    @RequiresPermissions(value = TAKEDRIVE_VIEW)
    @RequestMapping(value = "/form" , method = {RequestMethod.POST,RequestMethod.GET})
    public String form(HttpServletRequest request, String id, Model model,String meetingId) {
        if (!StringUtils.isEmpty(id)) {
            Takedrive takedrive = takedriveService.fetchById(id);
            takedrive.setContent_takedrive(ESAPI.encoder().decodeForHTML(takedrive.getContent_takedrive()));
            takedrive.setContent_takedrive_en(ESAPI.encoder().decodeForHTML(takedrive.getContent_takedrive_en()));
            model.addAttribute("data", takedrive);
        }
        model.addAttribute("meetingId", meetingId);
        return "takedrive/takedriveform";
    }

    //提交数据（新增、修改）
    @RequiresPermissions(value = TAKEDRIVE_EDIT)
    @RequestMapping(value = "/formData" , method = RequestMethod.POST)
    @ResponseBody
    public JSONObject formData(Takedrive takedrive, Model model, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        JSONObject rtnJson = new JSONObject();
        try {
            if (takedrive != null && takedrive.getId() != null) {
                takedrive.setUpdateBy(UserUtils.getUser().getId());
                takedriveService.update(takedrive);
                rtnJson.put("errorNo", 0);
            } else {
                takedrive.setNumber(codingruleUtils.getNumber(accountsId, Takedrive.class.getName()));
                takedrive.setAccountsId(accountsId);
                takedrive.setDelFlag(false);
                takedrive.setAccountsId(UserUtils.getmpaccounts(request));
                takedrive.setCreateBy(UserUtils.getUser().getId());
                takedrive.setUpdateBy(UserUtils.getUser().getId());
                takedriveService.save(takedrive);
                meetingService.synMobileMenu();
                rtnJson.put("errorNo", 2);
            }
        } catch (Exception e) {
            rtnJson.put("errorNo", 1);
        }
        return rtnJson;
    }

    //获取列表数据
    @RequiresPermissions(value = TAKEDRIVE_VIEW)
    @RequestMapping(value = "/listData" , method = {RequestMethod.GET,RequestMethod.POST})
    @ResponseBody
    public JSONObject listData(int iDisplayStart, int iDisplayLength, Takedrive takedrive, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        Conds conds = new Conds();
        conds.equal("del_flag", Constants.DEL_FLAG_0);
        conds.equal("accounts_id", accountsId);

        if (!StringUtils.isEmpty(takedrive.getNumber())) {
            conds.like("number", takedrive.getNumber());
        }
        if (!StringUtils.isEmpty(takedrive.getTakedrive_titile())) {
            conds.like("takedrive_titile", takedrive.getTakedrive_titile());
        }
        if (!StringUtils.isEmpty(takedrive.getMeetingId())) {
            conds.equal("meetingId", takedrive.getMeetingId());
        }
        Sort sort = new Sort("sort", OrderType.ASC);

        List<Takedrive> list = takedriveService.fetchSearchByPage(conds, sort, iDisplayStart, iDisplayLength);
        Integer counts = takedriveService.count(conds);
        JSONObject rtnJson = new JSONObject();
        rtnJson.put("iTotalRecords", counts);
        rtnJson.put("iTotalDisplayRecords", counts);
        rtnJson.put("aaData", list);
        return rtnJson;
    }

    //删除数据
    @RequiresPermissions(value = TAKEDRIVE_EDIT)
    @RequestMapping(value = "/delete",method = RequestMethod.POST)
    @ResponseBody
    public JSONObject delete(String id) {
        JSONObject rtnJosn = new JSONObject();
        try {
            takedriveService.delete(id);
            meetingService.synMobileMenu();
            rtnJosn.put("errorNo", 0);
        } catch (Exception e) {
            rtnJosn.put("errorNo", 1);
        }

        return rtnJosn;
    }

}
