package com.cftech.workshop.album_pic.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.base.codingrule.utils.CodingruleUtils;
import com.cftech.workshop.album_pic.model.Album_pic;
import com.cftech.workshop.album_pic.service.Album_picService;
import com.cftech.core.poi.ExcelKit;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.Constants;
import com.cftech.sys.security.PermissionSign;
import com.cftech.sys.security.UserUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.List;


/**
 * Controller
 * <p>
 * 权限字符串说明:
 * 查看:public static final String ALBUM_PIC_VIEW = "qy:album_pic:view"
 * 查看:public static final String ALBUM_PIC_EDIT = "qy:album_pic:edit"
 *
 * @author byj
 * @date: 2018-07-10 10:45
 */
@Slf4j
@Controller
@RequestMapping("/a/album_pic")
public class Album_picController {

    public static final String ALBUM_PIC_VIEW = "qy:album_pic:view";
    public static final String ALBUM_PIC_EDIT = "qy:album_pic:edit";

    @Autowired
    private Album_picService album_picService;
    @Autowired
    private CodingruleUtils codingruleUtils;


    //列表页面
    @RequiresPermissions(value = ALBUM_PIC_VIEW)
    @RequestMapping(value = "/list",method = {RequestMethod.POST,RequestMethod.GET})
    public String list(HttpServletRequest request,String id, Model model,Long meetingId,String album_id) {
        Long accountId = UserUtils.getmpaccounts(request);
        model.addAttribute("accountId", accountId);
        model.addAttribute("meetingId",meetingId);
        model.addAttribute("album_id",album_id);
        model.addAttribute("id",id);
        return "album_pic/album_piclist";
    }

    //编辑页面（新增、修改）
    @RequiresPermissions(value = ALBUM_PIC_VIEW)
    @RequestMapping(value = "/form",method = {RequestMethod.POST,RequestMethod.GET})
    public String form(HttpServletRequest request, String id, Model model ,Long meetingId,String album_id) {
        if (!StringUtils.isEmpty(id)) {
            Album_pic album_pic = album_picService.fetchById(id);
            model.addAttribute("data", album_pic);
            model.addAttribute("album_id", album_id);
        }
        model.addAttribute("meetingId",meetingId);
        model.addAttribute("album_id", album_id);
        return "album_pic/album_picform";
    }

    //提交数据（新增、修改）
    @RequiresPermissions(value = ALBUM_PIC_EDIT)
    @RequestMapping(value = "/formData" , method = RequestMethod.POST)
    @ResponseBody
    public JSONObject formData(Album_pic album_pic, Model model, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        JSONObject rtnJson = new JSONObject();
        try {
            if (album_pic != null && album_pic.getId() != null) {
                album_pic.setUpdateBy(UserUtils.getUser().getId());
                album_picService.update(album_pic);
                rtnJson.put("errorNo", 0);
            } else {
                album_pic.setNumber(codingruleUtils.getNumber(accountsId, Album_pic.class.getName()));
                album_pic.setAccountsId(accountsId);
                album_pic.setDelFlag(false);
                album_pic.setAccountsId(UserUtils.getmpaccounts(request));
                album_pic.setCreateBy(UserUtils.getUser().getId());
                album_pic.setUpdateBy(UserUtils.getUser().getId());
                album_picService.save(album_pic);
                rtnJson.put("errorNo", 2);
            }
        } catch (Exception e) {
            rtnJson.put("errorNo", 1);
        }
        return rtnJson;
    }

    //获取列表数据
    @RequiresPermissions(value = ALBUM_PIC_VIEW)
    @RequestMapping(value = "/listData",method = {RequestMethod.POST,RequestMethod.GET})
    @ResponseBody
    public JSONObject listData(int iDisplayStart, int iDisplayLength, Album_pic album_pic, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        Conds conds = new Conds();
        conds.equal("del_flag", Constants.DEL_FLAG_0);
        conds.equal("accounts_id", accountsId);
        if(!UserUtils.isAdmin()){
            conds.equal("create_by", UserUtils.getUser().getId());
        }
        if (!StringUtils.isEmpty(album_pic.getNumber())) {
            conds.like("number", album_pic.getNumber());
        }
        if (!StringUtils.isEmpty(album_pic.getAlbum_id())) {
            conds.equal("album_id", album_pic.getAlbum_id());
        }
        Sort sort = new Sort("create_time", OrderType.DESC);

        List<Album_pic> list = album_picService.fetchSearchByPage(conds, sort, iDisplayStart, iDisplayLength);
        Integer counts = album_picService.count(conds);
        JSONObject rtnJson = new JSONObject();
        rtnJson.put("iTotalRecords", counts);
        rtnJson.put("iTotalDisplayRecords", counts);
        rtnJson.put("aaData", list);
        return rtnJson;
    }

    //删除数据
    @RequiresPermissions(value = ALBUM_PIC_EDIT)
    @RequestMapping(value = "/delete" , method = RequestMethod.POST)
    @ResponseBody
    public JSONObject delete(String id) {
        JSONObject rtnJosn = new JSONObject();
        try {
            album_picService.delete(id);
            rtnJosn.put("errorNo", 0);
        } catch (Exception e) {
            rtnJosn.put("errorNo", 1);
        }
        return rtnJosn;
    }

}
