package com.cftech.mp.area.service.impl;

import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.mp.area.dao.AreaMapper;
import com.cftech.mp.area.model.Area;
import com.cftech.mp.area.model.AreaDto;
import com.cftech.mp.area.service.AreaService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * areaService
 * Created by lisw 25/08/2016.
 */
@Service("areaService")
public class AreaServiceImpl extends GenericServiceImpl<Area> implements AreaService {

	/**
	 * areaMapper
	 */
	@Autowired
	@Qualifier("areaMapper")
	private AreaMapper areaDao;

	@Override
	public GenericDao<Area> getGenericMapper() {
		return areaDao;
	}

	@Override
	public List<AreaDto> areaList() {
		return areaDao.areaList();
	}

	@Override
	@CacheEvict(value="areaCache",allEntries=true)
	public boolean saveCache(Area area) {
		return this.save(area);
	}

	@Override
	@CacheEvict(value="areaCache",allEntries=true)
	public boolean updateCache(Area area) {
		return this.update(area);
	}
}
