package com.cftech.common.typeform.model;

import com.cftech.core.poi.ExportConfig;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 申请类型单
 *
 * @author faye
 * @date: 2019-08-14 16:31
 */
@Data
public class Typeform implements Serializable {

    /* 主键id */
    private Long id;
    /* 类型名 */
    @ExportConfig(value = "类型名", width = 100)
    private String name;
    /* 需特批金额 */
    @ExportConfig(value = "需特批金额", width = 100)
    private String price;
    /* 二维码 */
    //@ExportConfig(value = "二维码", width = 100)
    private String qrcode;
    /* 所属的账号 */
    private Long accountsId;
    /* 删除标识 */
    private boolean delFlag;
    /* 状态 */
    private String status;
    /* 创建时间 */
    private Date createTime;
    /* 更新时间 */
    private Date updateTime;
    /* 备注 */
    private String description;
    /* 创建人 */
    private Long createBy;
    /* 更新人 */
    private Long updateBy;

    private Integer sort;

    public Typeform() {
        this.delFlag = false;
        this.status = "0";
    }

}