package com.cftech.base.org.service.impl;


import com.cftech.base.org.dao.QyuserMapper;
import com.cftech.base.org.dao.TerminalUserMapper;
import com.cftech.base.org.model.TerminalUser;
import com.cftech.base.org.service.TerminalUserService;
import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * terminalUserService
 * Created by lisw 20/02/2017.
 */
@Service("terminalUserService")
public class TerminalUserServiceImpl extends GenericServiceImpl<TerminalUser> implements TerminalUserService {

	/**
	 * terminalUserMapper
	 */
	@Autowired
	@Qualifier("terminalUserMapper")
	private TerminalUserMapper terminalUserMapper;
	
	@Autowired
	private QyuserMapper qyUserMapper;

	@Override
	public GenericDao<TerminalUser> getGenericMapper() {
		return terminalUserMapper;
	}

	/* (non-Javadoc)
	 * @see com.cftech.qy.terminal.service.TerminalUserService#getTerminalPro(java.lang.Long)
	 */
	@Override
	public Map<String,Object> getTerminalPro(Long id) {
		return terminalUserMapper.getTerminalPro(id);
	}

	/* (non-Javadoc)
	 * @see com.cftech.qy.terminal.service.TerminalUserService#saveBatchTerminalCommodity(java.lang.Long, java.lang.String[])
	 */
	@Override
	public int saveBatchTerminalCommodity(Long userId, String[] terminalIds,String wxUserId) {
		try {
			/**
			 * 批量绑定终端
			 */
			terminalUserMapper.removeTerminal(userId);
			if(terminalIds!=null && terminalIds.length>0 && com.cftech.core.util.StringUtils.isNotBlank(terminalIds[0])){
				Map<String,Object> params = new HashMap<String, Object>();
				params.put("userId", userId);
				params.put("terminalsids",terminalIds);
				
				/**
				 * 为终端填充终端负责人账号
				 */
				Map<String,Object> userObjectParams = new HashMap<String, Object>();
				userObjectParams.put("terminals", terminalIds);
				userObjectParams.put("wxUserId", wxUserId);
				qyUserMapper.updateUserTerminal(userObjectParams);
				return terminalUserMapper.saveBatchTerminalUser(params);
			}else{
				return 0;
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return 0;
	}
}
