package com.cftech.questionnaire.core.papercategory.service.impl;

import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.questionnaire.core.papercategory.dao.PapercategoryMapper;
import com.cftech.questionnaire.core.papercategory.model.Papercategory;
import com.cftech.questionnaire.core.papercategory.service.PapercategoryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 问卷分类ServiceImpl
 *
 * @author Neil
 * @date: 2017-05-23 13:24
 */
@Service("papercategoryService")
public class PapercategoryServiceImpl extends GenericServiceImpl<Papercategory> implements PapercategoryService {

    @Autowired
    @Qualifier("papercategoryMapper")
    private PapercategoryMapper papercategoryMapper;

    @Override
    public GenericDao<Papercategory> getGenericMapper() {
        return papercategoryMapper;
    }

    @Override
    public List<Papercategory> fetchSearchByPage(Long parentId, Conds conds, Sort sort, int page, int pageSize) {
        Map<String, Object> params = new HashMap<>();
        if (parentId == 0) {
            params.put("pId", parentId);
        } else {
            params.put("pId", "," + parentId);
        }

        params.put("conds", conds);
        params.put("offset", page > 0 ? page : 0);
        params.put("limit", pageSize > 0 ? pageSize : 0);
        params.put("sort", sort);
        return papercategoryMapper.fetchSearchByPage(params);
    }

    @Override
    public List<Papercategory> fetchTreeByPage(Conds conds, Sort sort, int page, int pageSize) {
        Map<String, Object> params = new HashMap<>();
        params.put("conds", conds);
        params.put("offset", page > 0 ? page : 0);
        params.put("limit", pageSize > 0 ? pageSize : 0);
        params.put("sort", sort);
        return papercategoryMapper.fetchTreeByPage(params);
    }

    @Override
    public int count(Long parentId, Conds conds) {
        Map<String, Object> params = new HashMap<>();
        params.put("pId", parentId);
        params.put("conds", conds);
        return papercategoryMapper.count(params);
    }
}