package com.cftech.addresst.service;

import com.alibaba.fastjson.JSONObject;
import com.cftech.addresst.model.Address;
import com.cftech.addresst.model.Area;
import com.cftech.core.generic.GenericService;

import javax.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.List;

/**
 * 收货地址管理Service
 *
 * @author Licc
 * @date: 2020-09-29 17:17
 */
public interface AddressService extends GenericService<Address> {

    List<Area> listArea();

    /**
     * @return
     * @Description 个人收货地址数据回填
     * @Date 9:53 2020/10/20
     * @Param
     **/
    JSONObject addressList(String openId, String appId, Long addressId);

    /**
     * @return
     * @Description 根据id查询收货地址
     * @Date 9:53 2020/10/20
     * @Param
     **/
    JSONObject addressId(Long id, String appId);

    /**
     * @return
     * @Description 个人收货地址新增
     * @Date 9:53 2020/10/20
     * @Param
     **/
    JSONObject addressAdd(Address address);

    /**
     * @return
     * @Author Licc
     * @Description 个人收货地址修改
     * @Date 15:23 2020/10/20
     * @Param
     **/
    JSONObject updateAddress(Address address);

    /**
     * @return
     * @Author Licc
     * @Description 个人收货地址删除
     * @Date 15:53 2020/10/20
     * @Param
     **/
    JSONObject deleteAddress(String id, String appId);

}
