package com.cftech.behavior.qrcode.record.model;

import com.cftech.core.poi.ExportConfig;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 扫码记录
 *
 * @author faye
 * @date: 2017-09-25 11:51
 */
@Data
public class QrcodeRecord implements Serializable {

    /* 主键id */
    private Long id;
    /* 编码 */
    //@ExportConfig(value = "编码", width = 100)
    private String number;
    /* openid */
    private String openid;
    /* 二维码类型 */
    //@ExportConfig(value = "二维码类型", width = 100)
    private String type;//store 门店
    /* 二维码标识 */
    @ExportConfig(value = "二维码标识", width = 100)
    private String ticket;
    /* 姓名 */
    @ExportConfig(value = "姓名", width = 100)
    private String empname;
    /* 扫码方式记录id */
   // @ExportConfig(value = "扫码方式记录id", width = 100)
    private String keywords;
    /* 电话 */
    @ExportConfig(value = "电话", width = 100)
    private String mobile;
    /* 所属的账号 */
    private Long accountsId;
    /* 删除标识 */
    private boolean delFlag;
    /* 状态 */
    private String status;
    /* 创建时间 */
    private Date createTime;
    /* 更新时间 */
    private Date updateTime;
    /* 备注 */
    private String description;
    /* 创建人 */
    private Long createBy;
    /* 更新人 */
    private Long updateBy;

    private String objName;

    public QrcodeRecord() {
        this.delFlag = false;
        this.status = "0";
    }

}