package com.cftech.sys.controller;

import com.cftech.accounts.model.MpAccountsEntity;
import com.cftech.accounts.service.MpAccountsService;
import com.cftech.sys.model.Permission;
import com.cftech.sys.model.User;
import com.cftech.sys.model.UserRole;
import com.cftech.sys.security.UserUtils;
import com.cftech.sys.service.PermissionService;
import com.cftech.sys.service.RoleService;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * 公共视图控制器
 * 
 **/
@Controller
@RequestMapping("/a")
public class CommonController {
	
	@Autowired
	private PermissionService permissionService;

	@Autowired
	private MpAccountsService mpAccountService;
	
	@Autowired
	private RoleService roleService;

	
	
    /**
     * 首页
     * 
     * @param request
     * @return
     */
    @RequestMapping(value = "index",method = {RequestMethod.GET,RequestMethod.POST})
	public String index(HttpServletRequest request, Model model) {
		Subject subject = SecurityUtils.getSubject();
		String accountsId = request.getParameter("accountsId");
		User currentUser = UserUtils.getUser();
		List<MpAccountsEntity> qyList = mpAccountService.getQyAccounts(currentUser.getId());
		model.addAttribute("qyList", qyList);

		List<MpAccountsEntity> mpList = mpAccountService.getMpAccounts(currentUser.getId());
		model.addAttribute("mpList", mpList);

        model.addAttribute("defaultAccountsId",accountsId);

		MpAccountsEntity accountsEntity = null;

		if (StringUtils.isNotBlank(accountsId)) {

			accountsEntity = mpAccountService.getDetail(Long.valueOf(accountsId));
		} else {
			if (currentUser.getDefaultAccId() != null) {
				accountsEntity = mpAccountService.getDetail(currentUser.getDefaultAccId());
			}
		}

		if (accountsEntity != null) {
			String roleids = "";
			List<UserRole> userRole = roleService.selectRolesByUserAccountsId(currentUser.getId(), accountsEntity.getId());
			for (int i = 0; i < userRole.size(); i++) {
				if (i == userRole.size() - 1) {
					roleids += userRole.get(i).getRoleId();
				} else {
					roleids += userRole.get(i).getRoleId() + ",";
				}
			}
			if (StringUtils.isNotBlank(roleids)) {
				List<Permission> permissions = permissionService.getMenuByRoles(roleids);
				model.addAttribute("permission", permissions);

				List<Permission> allPerms = permissionService.getPermissionsByRoles(roleids);
				request.getSession().setAttribute("permission", allPerms);
			}

			//获得当前账号
			String avatar = mpAccountService.getByQyUserAvater(currentUser.getId());
			if (StringUtils.isBlank(avatar)) {
				request.getSession().setAttribute("USER_AVATAR", "dist/img/avatar_.jpg");
			} else {
				request.getSession().setAttribute("USER_AVATAR", avatar);
			}

			//获得当前账号
			request.getSession().setAttribute("mpaccounts", accountsEntity.getId());
			request.getSession().setAttribute("isshow", "2");//不显示，首页报表图
			return "index";
		} else {
			return "welcome";
		}
	}

	@RequestMapping(value = "showpage",method = {RequestMethod.GET,RequestMethod.POST})
    public String showpage(HttpServletRequest request,Model model,Long id) 
    {
    	if(id==null){
    		id= UserUtils.getmpaccounts(request);
    	}
    	User currentUser = UserUtils.getUser();

    	
    	String roleids= "";
    	List<UserRole> userRole = roleService.selectRolesByUserAccountsId(currentUser.getId(), id);
    	for(int i =0;i<userRole.size();i++){
    		if(i==userRole.size()-1){
    			roleids+=userRole.get(i).getRoleId();
    		}else{
    			roleids+=userRole.get(i).getRoleId()+",";
    		}
    	}
    	if(StringUtils.isNotBlank(roleids))
    	{
    		model.addAttribute("permission",permissionService.getMenuByRoles(roleids));
    	}
    	//获取企业微信头像


    	//获得当前账号 
    	MpAccountsEntity mpAccount = mpAccountService.getDetail(id);
		String avatar = mpAccountService.getByQyUserAvater(currentUser.getId());
		request.getSession().setAttribute("USER_AVATAR", avatar);
    	request.getSession().setAttribute("mpaccountsDescription", mpAccount.getDescription());
    	request.getSession().setAttribute("mpaccounts", id);
    	//调用微信接口获得 关注数据 详情
        return "index";
    }

    @RequestMapping("501")
	public String functioning(){
		return "501";
	}
    

}