package com.cftech.accounts.dao;

import com.cftech.accounts.model.MpAccountsEntity;
import com.cftech.core.generic.GenericDao;

import java.util.List;
import java.util.Map;


public interface MpAccountsMapper extends GenericDao<MpAccountsEntity> {

    long insert(MpAccountsEntity mpAccounts);

    List<MpAccountsEntity> getMpAccounts(Long userid);

    List<MpAccountsEntity> getQyAccounts(Long userid);

    long updateByPrimaryKey(MpAccountsEntity mpAccounts);

    int deleteByPrimaryKey(Long id);

    MpAccountsEntity getDetail(Long userid);

    List<MpAccountsEntity> getAllMpAccounts();

    List<MpAccountsEntity> getAllQyAccounts();

    List<MpAccountsEntity> getAllAccounts(Long userid);

    MpAccountsEntity getMpAccountsAppid(String appId);

    int deleteByUserAccount(Map<String, Object> params);

    int insertUserAccount(Map<String, Object> params);

    int getUserAccounts(Map<String, Object> params);

    String getByQyUserAvater(Long id);
}
