var register = (function () {
  'use strict';
  var Register = function (params) {
    var p = this;
    p.params = {
      appid: '',
      accountsId: '',
      cfApp: null,
      devMode: false,
      submitApi: G.baseUri() + '/mobile/auth/feedback/save',
      vt: ''
    };
    for (var param in params) {
      p.params[param] = params[param];
    }
    var cfApp = p.params.cfApp;
    p.english = cfApp.getQueryString('english') == 1 ? true : false;
    if (p.params.devMode) {
      p.params.dataApi = 'json/code.json';
      p.params.returnqustion = 'json/code.json';
    }


    var serverId;

    /**
     * 判断app字段
     * @returns 是否app有值
     */
    var validAppField = function () {
      if (!p.params.appid || p.params.appid == '') {
        return false;
      } else {
        return true;
      }
    };

    /**
     * 确认初始化的app 和tokenId 两个值是否都存在
     * 如果不存在则获取一次,获取不到则初始化失败
     * @returns 初始化基础字段是否成功
     */
    var initBaseFields = function () {
      if (!validAppField()) {
        p.params.appid = cfApp.getQueryString('appid');
        //p.params.accountsId = cfApp.getQueryString('accountsId');
      }



      //如果获取不到app和tokenId,则直接从传入的CfApp中获取值
      if (!validAppField()) {
        if (p.params.cfApp) {
          p.params.appid = cfApp.getAppId();
          //p.params.tokenId = cfApp.getTokenId();
        }
      }
      p.empInfo = cfApp.getMpInfo();
      p.params.accountsId = p.empInfo.accountsId;
      return validAppField();
    };

    /**
     * 初始化组件
     * @returns {boolean}
     */


    p.init = function () {


      if (initBaseFields()) {
        uploadCard();
        gender();
        log();
        submit();
        returnqustions();
        $('.language').click(function () {
          if (p.english) {
            location.href = 'exhibi-inquiries.html?appid=' + p.params.appid + '&id=' + cfApp.getQueryString('id');
          } else {
            location.href = 'exhibi-inquiries-english.html?appid=' + p.params.appid + '&id=' + cfApp.getQueryString('id')+ '&english=1';
          }
        })
        return true;
      } else {
        return false;
      }
    };
    var log = function () {
      var formdata = {
        openid: p.empInfo.openId,
        module: "意见反馈",
        modulename: "意见反馈",
        keyword: "意见反馈",
        keywordid: cfApp.getQueryString('id'),
        vt: new Date().getTime(),
        appid: cfApp.getQueryString('appid'),
        url: location.href
      };
      G.ajax(G.devModePost, '/schaeffler/mobile/testAsync/doLOg', formdata, function (retdata) {


      });
    }
    var sex = cfApp.getQueryString('sex');
    if(sex == '女'){
      $('.gender #man').removeClass('choose');
      $('.gender #woman').addClass('choose');
    }
    //选择性别
    var gender = function () {
      $('.submitheader>img').click(function () {
        if(p.english){
          location.href="exhibition-english.html?appid="+cfApp.getQueryString("appid")+"&id="+cfApp.getQueryString("id");
        }else{
          location.href="exhibition.html?appid="+cfApp.getQueryString("appid")+"&id="+cfApp.getQueryString("id");
        }

      });
    }

      //上传图片
      var uploadCard = function () {

          $('#upload').click(function () {
              var localIds;

              wx.chooseImage({
                  count: 1, // 默认9
                  sizeType: ['original', 'compressed'], // 可以指定是原图还是压缩图，默认二者都有
                  sourceType: ['album', 'camera'], // 可以指定来源是相册还是相机，默认二者都有
                  success: function (res) {
                      alert(res.localIds.toString());
                      localIds = res.localIds.toString(); // 返回选定照片的本地ID列表，localId可以作为img标签的src属性显示图片
                      wx.uploadImage({
                          localId: localIds, // 需要上传的图片的本地ID，由chooseImage接口获得
                          isShowProgressTips: 1, // 默认为1，显示进度提示
                          success: function (res) {
                              serverId = res.serverId; // 返回图片的服务器端ID
                              $('#upload img').attr('src', localIds);
                              $('#upload img').show();
                              $("#upload .card-show").css("opacity","1");
                          }
                      });
                  }
              });
          });

      }

    //返回咨询信息
    var returnqustions = function(){
      var formdata = {
        exhibi_id:cfApp.getQueryString('id')
      }
      G.ajax(G.devModePost, p.params.returnqustion, formdata, function (retdata) {
        if(retdata.errorNo == 0){
           $('#name').val(retdata.data.name);
          $('#company').val(retdata.data.company);
          $('#contact').val(retdata.data.contact);
        }else if(retdata.errorNo == 1){
          $.modal({
            title: "",
            text: '<span class="color-green">获取异常！</span></br>System error',
            buttons: [{
              text: "确定OK"
            }]
          });
        }else if(retdata.errorNo == 2){
          $.modal({
            title: "",
            text: '<span class="color-green">参数错误！</span></br>Parameter  error',
            buttons: [{
              text: "确定OK"
            }]
          });
        }
      })
    }

    //提交相关问询
    var submit = function () {
      $('#submit').click(function () {

        var name = $('#name').val();
        if (StringValidateUtils.isEmpty(name)) {
          $.modal({
            title: "",
            text: '<span class="color-green">请输入您的姓名！</span><br>Please input the<br>name',
            buttons: [{
              text: "确定OK"
            }]
          });


          return false;

        }
        var company = $('#company').val();
        if (StringValidateUtils.isEmpty(company)) {
          $.modal({
            title: "",
            text: '<span class="color-green">请输入您的公司！</span><br>Please input the<br>company',
            buttons: [{
              text: "确定OK"
            }]
          });
          return false;
        }

        var contact = $('#contact').val();
        if (StringValidateUtils.isEmpty(contact)) {
          $.modal({
            title: "",
            text: '<span class="color-green">请输入您的联系方式！</span><br>Please input the<br>contact',
            buttons: [{
              text: "确定OK"
            }]
          });
          return false;
        }
        var problem = $('#problem').val();
        if(StringValidateUtils.isEmpty(problem)){
          $.modal({
            title:"",
            text:'<span class="color-green">请输入您想咨询的问题！</span><br>Please input the<br>question',
            buttons:[{
              text:"确定OK"
            }]
          })
          return false;
        }
        var formdata = {
          accountsId: p.params.accountsId,
          open_id: p.empInfo.openId,
          field1: p.empInfo.openId,
          name: name,
          commpany:company,
          content:problem,
          phone:contact,
          inquiries_picture:serverId
        }
        G.ajax(G.devModePost, p.params.submitApi, formdata, function (retdata) {
          if (retdata.errorNo == '0') {
            //注册成功
            $.modal({
              title: "",
              text: '<span class="color-green">提交成功！</span></br>Success',
              buttons: [{
                text: "确定OK",
                onClick:function(){

                }
              }]
            });
          } else {
            $.modal({
                title: "",
                text: '<span class="color-green">获取异常！</span></br>System error',
                buttons: [{
                  text: "确定OK"
                }]
              });
          }
        })



      })
    }


  };

  return Register;
})();