package com.cftech.workshop.screen.model;

import com.cftech.core.poi.ExportConfig;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author byj
 * @date: 2018-10-22 15:41
 */
@Data
public class Screen implements Serializable {

    /* 主键id */
    private Long id;
    /* 编码 */
    @ExportConfig(value = "编码", width = 100)
    private String number;
    /* 会场 */
    @ExportConfig(value = "会场", width = 100)
    private String customiz_id;
    /* 主题 */
    @ExportConfig(value = "主题", width = 100)
    private String topic_id;
    /* 研讨会ID */
    @ExportConfig(value = "研讨会ID", width = 100)
    private Long meetingId;
    /* 咨询问题 */
    @ExportConfig(value = "咨询问题", width = 100)
    private String question;
    /* 微信OPENID */
    @ExportConfig(value = "微信OPENID", width = 100)
    private String open_id;
    /* 所属的账号 */
    private Long accountsId;
    /* 删除标识 */
    private boolean delFlag;
    /* 状态 */
    private String status;
    /* 创建时间 */
    private Date createTime;
    /* 更新时间 */
    private Date updateTime;
    /* 备注 */
    private String description;
    /* 创建人 */
    private Long createBy;
    /* 更新人 */
    private Long updateBy;

    private String nickname;

    public Screen() {
        this.delFlag = false;
        this.status = "0";
    }

}