package com.cftech.workshop.album.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.base.codingrule.utils.CodingruleUtils;
import com.cftech.workshop.album.model.Album;
import com.cftech.workshop.album.service.AlbumService;
import com.cftech.core.poi.ExcelKit;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.Constants;
import com.cftech.sys.security.PermissionSign;
import com.cftech.sys.security.UserUtils;
import com.cftech.workshop.meeting.model.Meeting;
import com.cftech.workshop.meeting.service.MeetingService;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.List;


/**
 * Controller
 * <p>
 * 权限字符串说明:
 * 查看:public static final String ALBUM_VIEW = "qy:album:view"
 * 查看:public static final String ALBUM_EDIT = "qy:album:edit"
 *
 * @author byj
 * @date: 2018-06-29 15:06
 */
@Slf4j
@Controller
@RequestMapping("/a/album")
public class AlbumController {

    public static final String ALBUM_VIEW = "qy:album:view";
    public static final String ALBUM_EDIT = "qy:album:edit";

    @Autowired
    private AlbumService albumService;
    @Autowired
    private CodingruleUtils codingruleUtils;

    @Autowired
    private MeetingService meetingService;


    //列表页面
    @RequiresPermissions(value = ALBUM_VIEW)
    @RequestMapping("/list")
    public String list(HttpServletRequest request, Model model,Long meetingId) {
        Long accountId = UserUtils.getmpaccounts(request);
        model.addAttribute("accountId", accountId);
        model.addAttribute("meetingId",meetingId);
        return "album/albumlist";
    }

    //编辑页面（新增、修改）
    @RequiresPermissions(value = ALBUM_VIEW)
    @RequestMapping("/form")
    public String form(HttpServletRequest request, String id, Model model,Long meetingId) {
        if (!StringUtils.isEmpty(id)) {
            Album album = albumService.fetchById(id);
            model.addAttribute("data", album);
        }
        model.addAttribute("meetingId",meetingId);
        return "album/albumform";
    }

    //提交数据（新增、修改）
    @RequiresPermissions(value = ALBUM_EDIT)
    @RequestMapping("/formData")
    @ResponseBody
    public JSONObject formData(Album album, Model model, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        JSONObject rtnJson = new JSONObject();
        try {
            if (album != null && album.getId() != null) {
                album.setUpdateBy(UserUtils.getUser().getId());
                albumService.update(album);
                rtnJson.put("errorNo", 0);
            } else {
                album.setNumber(codingruleUtils.getNumber(accountsId, Album.class.getName()));
                album.setAccountsId(accountsId);
                album.setDelFlag(false);
                album.setAccountsId(UserUtils.getmpaccounts(request));
                album.setCreateBy(UserUtils.getUser().getId());
                album.setUpdateBy(UserUtils.getUser().getId());
                albumService.save(album);
                meetingService.synMobileMenu();
                rtnJson.put("errorNo", 2);
            }

        } catch (Exception e) {
            rtnJson.put("errorNo", 1);
        }
        return rtnJson;
    }

    //获取列表数据
    @RequiresPermissions(value = ALBUM_VIEW)
    @RequestMapping(value = "/listData")
    @ResponseBody
    public JSONObject listData(int iDisplayStart, int iDisplayLength, Album album, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        Conds conds = new Conds();
        conds.equal("del_flag", Constants.DEL_FLAG_0);
        conds.equal("accounts_id", accountsId);
        if (!StringUtils.isEmpty(album.getNumber())) {
            conds.like("number", album.getNumber());
        }
        if (!StringUtils.isEmpty(album.getWorkshop_id())) {
            conds.equal("workshop_id", album.getWorkshop_id());
        }
        if (!StringUtils.isEmpty(album.getAlbum_describe())) {
            conds.like("album_describe", album.getAlbum_describe());
        }
        if (!StringUtils.isEmpty(album.getAlbum_describe_en())) {
            conds.like("album_describe_en", album.getAlbum_describe_en());
        }
        if(!StringUtils.isEmpty(album.getAlbum_name())){
            conds.like("album_name",album.getAlbum_name());
        }
        Sort sort = new Sort("sort", OrderType.ASC);

        List<Album> list = albumService.fetchSearchByPage(conds, sort, iDisplayStart, iDisplayLength);
        Integer counts = albumService.count(conds);
        JSONObject rtnJson = new JSONObject();
        rtnJson.put("iTotalRecords", counts);
        rtnJson.put("iTotalDisplayRecords", counts);
        rtnJson.put("aaData", list);
        return rtnJson;
    }

    //删除数据
    @RequiresPermissions(value = ALBUM_EDIT)
    @RequestMapping("/delete")
    @ResponseBody
    public JSONObject delete(String id) {
        JSONObject rtnJosn = new JSONObject();
        try {
            albumService.delete(id);
            meetingService.synMobileMenu();
            rtnJosn.put("errorNo", 0);
        } catch (Exception e) {
            rtnJosn.put("errorNo", 1);
        }

        return rtnJosn;
    }



}
