//import com.cftech.common.promotionstock.model.PStockStatisticalDto;
//import com.cftech.common.promotionstock.service.PromotionStockService;
//import com.cftech.core.util.StringUtils;
//import org.apache.poi.hssf.usermodel.HSSFFont;
//import org.apache.poi.hssf.usermodel.HSSFWorkbook;
//import org.apache.poi.hssf.util.HSSFColor;
//import org.apache.poi.ss.usermodel.Cell;
//import org.apache.poi.ss.usermodel.CellStyle;
//import org.apache.poi.ss.usermodel.Row;
//import org.apache.poi.ss.usermodel.Sheet;
//import org.apache.poi.ss.util.CellRangeAddress;
//import org.junit.Test;
//import org.junit.runner.RunWith;
//import org.owasp.esapi.ESAPI;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.test.context.ContextConfiguration;
//import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
//import java.io.FileOutputStream;
//import java.io.IOException;
//import java.math.BigDecimal;
//import java.util.*;
//
///**
// * @author lisw
// * @program schaeffler
// * @description 促销品统计报表
// * @createDate 2020-01-17 10:00:29
// **/
//@RunWith(SpringJUnit4ClassRunner.class)
//@ContextConfiguration(locations={"classpath*:applicationContext*.xml"})
//public class StatisticalExportUtil {
//
//    private StatisticalCommonExportUtil statisticalCommonExportUtil =null;
//
//    private String startDate = null;
//
//    private String endDate = null;
//
//    @Autowired
//    private PromotionStockService promotionStockService;
//
//    @Test
//    public void test1(){
//        System.out.println(ESAPI.encoder().decodeForHTML("&amp;"));
//    }
//
//    @Test
//    public void test() throws IOException {
//        String fileName = "促销品统计报表";
//        startDate = "2019-1-1";
//        endDate = "2020-5-1";
//        // 创建excel文件对象
//        HSSFWorkbook wb = new HSSFWorkbook();
//        statisticalCommonExportUtil = new StatisticalCommonExportUtil(wb);
//        // 创建sheet
//        Sheet sheetManagerStock = wb.createSheet("管理员库存统计");
//        Sheet sheetSupplierStock = wb.createSheet("供应商发货统计");
//        Sheet sheetDeptStatistical = wb.createSheet("按部门领用统计");
//        Sheet sheetUseStatistical = wb.createSheet("按用途领用统计");
//        Sheet sheetEvaluateStatistical = wb.createSheet("评价信息统计");
//        Sheet sheetPromotionStatistical = wb.createSheet("促销品发放明细");
//        List<PStockStatisticalDto> pStockStatisticalDtos = promotionStockService.fetchPStockStatistical(startDate,endDate);
//
//        Map<String,String[]> rtnMap = parseContentStock(pStockStatisticalDtos);
//        String[] managerArr = rtnMap.get("m");
//        String[] supplierArr = rtnMap.get("s");
//        //第一个sheet数据填充
//        createHeaderFirsts(sheetManagerStock);
//        String [] sheetManagerTitles = new String[]{"管理员库存统计","管理员本月发货明细","管理员本月发货金额","管理员本月剩余库存","管理员本月剩余库存金额"};
//        createContentRow(sheetManagerStock,sheetManagerTitles,managerArr);
//        //合并单元格
//        sheetManagerMerged(sheetManagerStock);
//        //第二个sheet
//        createHeaderFirsts(sheetSupplierStock);
//        String [] sheetSupplierTitles = new String[]{"供应商发货统计","供应商发货明细","供应商发货金额","供应商物流金额","需支付给供应商的金额"};
//        createContentRow(sheetSupplierStock,sheetSupplierTitles,supplierArr);
//        //合并单元格
//        sheetManagerMerged(sheetSupplierStock);
//        wb.write(new FileOutputStream("/Users/lisw/work/table2.xls"));
//    }
//
//    //解析内容
//    public Map<String,String[]> parseContentStock(List<PStockStatisticalDto> pStockStatisticalDtoList){
//        String [] managerArray;
//        String [] supplierArray;
//        Map<String,Integer> mgrantCountMap = new HashMap<>();//管理员发货明细  key 商品名称 value 商品发货数量，商品发货总金额
//        Map<String,Integer> sgrantCountMap = new HashMap<>(); // 供应商发货明细
//
//        BigDecimal mSumPrice = new BigDecimal("0");//管理员发货金额
//        BigDecimal sSumPrice = new BigDecimal("0"); //供应商发货金额
//
//
//        Map<String,Integer> mAfterStockMap = new HashMap<>();//管理员剩余库存明细
//        BigDecimal mAfterSumPrice = null; //管理员剩余库存金额
//
//        BigDecimal sLogisticsPrice = new BigDecimal("0"); //供应商物流金额
//
//        Map<Long,BigDecimal> stringBigDecimalMap = new HashMap<>(); //每个单子供应商物流金额暂存
//
//        Map<String,List<Map<String,String>>> departNameMap = new HashMap<>();//KEY 部门名称 , value>map>itemName,num,totalPrice
//
//
//        for(PStockStatisticalDto pStockStatisticalDto : pStockStatisticalDtoList){
//            String itemName = pStockStatisticalDto.getItemName();
//            Integer changeNum = pStockStatisticalDto.getChangeNum();//变动值 有可能是负数
//            BigDecimal priceBigDecimal = pStockStatisticalDto.getPrice();//单价
//            String type = pStockStatisticalDto.getType();
//            Integer afterStock = pStockStatisticalDto.getAfterChangeStock();//剩余库存
//            BigDecimal absChangNum = new BigDecimal(Math.abs(changeNum));//变动值的绝对值
//            BigDecimal singlePrice = absChangNum.multiply(priceBigDecimal);//促销品总价（单价*数量)
//            Integer count=0;
//            String deptName = pStockStatisticalDto.getDname();
//
////            List<Map<String,String>> dMap = new ArrayList<>();
////            if(departNameMap.containsKey(deptName)){
////                dMap = departNameMap.get(deptName);
////                for(Map<String,String> m : dMap){
////                    if(m.get("itemName").equals(itemName)){
////
////                    }
////                }
////            }else{
////                Map<String,String> map = new HashMap<>();
////                map.put("itemName",itemName);
////                map.put("totalPrice",singlePrice.toString());
////                map.put("num",absChangNum.toString());
////                dMap.add(map);
////            }
//            if("10".equals(type)){
//                if(changeNum<0){//发货减少库存为负
//                    if(mgrantCountMap.containsKey(itemName)){//非第一次插入时，取出原来的发货量进行累加
//                        count = mgrantCountMap.get(itemName);
//                        count+=absChangNum.intValue();
//                        mgrantCountMap.put(itemName,count);
//                    }else{
//                        mgrantCountMap.put(itemName,absChangNum.intValue());//第一次将发货数量插入map中
//                    }
//
//                    mSumPrice=mSumPrice.add(singlePrice).setScale(2, BigDecimal.ROUND_HALF_UP);
//                }else if(changeNum>0 && "1".equals(pStockStatisticalDto.getStatus())){//退库记录逻辑处理
//                    if(mgrantCountMap.containsKey(itemName)){//非第一次插入时，取出原来的发货量进行扣减
//                        count = mgrantCountMap.get(itemName);
//                        count-=absChangNum.intValue();
//                        mgrantCountMap.put(itemName,count);
//                    }else{
//                        mgrantCountMap.put(itemName,0-(absChangNum.intValue()));//第一次将发货数量插入map中
//                    }
//                    mSumPrice=mSumPrice.subtract(singlePrice).setScale(2,BigDecimal.ROUND_HALF_UP);
//                }
//                /**
//                 * 根据库存明细进行倒叙排序查处的数据，
//                 * 每个商品的第一个的库存信息的剩余明细字段即为每个促销品的截止日期的最终剩余库存
//                 * 侬晓得伐？
//                 */
//                //第一次将此商品插入到Map，则第一次的时候此商品的剩余库存，就是本次搜索此商品的最终剩余库存
//                if(!mAfterStockMap.containsKey(itemName)){
//                    mAfterStockMap.put(itemName,afterStock);//剩余库存，仅会存入一次，以第一条记录的剩余库存作为本商品本次筛选的剩余库存
//                    if(mAfterSumPrice==null){
//                        mAfterSumPrice=new BigDecimal("0");
//                    }
//                    BigDecimal singlePromotionAfterStock = new BigDecimal(afterStock);//此商品截止日期的最终剩余库存
//                    BigDecimal singlePromotionTotal = singlePromotionAfterStock.multiply(priceBigDecimal);//此商品单价
//                    mAfterSumPrice=mAfterSumPrice.add(singlePromotionTotal).setScale(2, BigDecimal.ROUND_HALF_UP);//累加到所有促销品的剩余库存金额
//
//                }
//            }else if(changeNum!=null && changeNum<0 && "20".equals(type)){
//                if(sgrantCountMap.containsKey(itemName)){//
//                    count = sgrantCountMap.get(itemName);
//                    count+=absChangNum.intValue();
//                    sgrantCountMap.put(itemName,count);
//                }else{
//                    sgrantCountMap.put(itemName,absChangNum.intValue());
//                }
//                sSumPrice=sSumPrice.add(singlePrice).setScale(2, BigDecimal.ROUND_HALF_UP);
//                if(!stringBigDecimalMap.containsKey(pStockStatisticalDto.getAppformId()) && pStockStatisticalDto.getDisLogisticsPrice()!=null){//每单仅累加一次
//                    sLogisticsPrice=sLogisticsPrice.add(pStockStatisticalDto.getDisLogisticsPrice()).setScale(2,BigDecimal.ROUND_HALF_UP);
//                    stringBigDecimalMap.put(pStockStatisticalDto.getAppformId(),pStockStatisticalDto.getDisLogisticsPrice());
//                }
//            }
//
//            /**
//             * 填充部门数据
//             */
//
//
//
//
//
//        }
//        //将管理员转换为数组
//        Set<String> keys = mgrantCountMap.keySet();
//        StringBuffer mgrantCountMapBuffer = new StringBuffer();
//        for(String key:keys){
//            mgrantCountMapBuffer.append(key+"*"+mgrantCountMap.get(key)+";"+statisticalCommonExportUtil.getLineStr());
//        }
//        String mgrantPrice = mSumPrice==null?"":mSumPrice.toString();
//
//        Set<String> keysAfterStockKeys = mAfterStockMap.keySet();
//        StringBuffer mAfterMapBuffer = new StringBuffer();
//        for(String key:keysAfterStockKeys){
//            mAfterMapBuffer.append(key+"*"+mAfterStockMap.get(key)+";"+statisticalCommonExportUtil.getLineStr());
//        }
//        String mAfterStockPrice = mAfterSumPrice==null?"":mAfterSumPrice.toString();
//        managerArray = new String[]{"",mgrantCountMapBuffer.toString(),mgrantPrice,mAfterMapBuffer.toString(),mAfterStockPrice};
//        //将供应商内容转换为数据
//        Set<String> supplierKeys = sgrantCountMap.keySet();
//        StringBuffer supplierCountMapBuffer = new StringBuffer();
//        for(String key:supplierKeys){
//            supplierCountMapBuffer.append(key+"*"+sgrantCountMap.get(key)+";"+statisticalCommonExportUtil.getLineStr());
//        }
//        String paySupplierPrice = sSumPrice.add(sLogisticsPrice).setScale(2, BigDecimal.ROUND_HALF_UP).toString();
//
//        supplierArray = new String[]{"",supplierCountMapBuffer.toString(),sSumPrice.toString(),sLogisticsPrice.toString(),paySupplierPrice};
//        Map<String,String []> rtnMap = new HashMap<>();
//        rtnMap.put("m",managerArray);
//        rtnMap.put("s",supplierArray);
//        return rtnMap;
//    }
//
//    //创建sheetManagerStock表头
//    public void createHeaderFirsts(Sheet sheet){
//        sheet.setDefaultColumnWidth(30);
//        Row row =sheet.createRow(0);
//        row.setHeight(statisticalCommonExportUtil.getRowHeight());
//        Cell cell =  row.createCell(0);
//        CellStyle cellStyle = statisticalCommonExportUtil.getGrey25CellStyle();
//        cellStyle.setAlignment(CellStyle.ALIGN_LEFT); // 水平布局：居左
//        cell.setCellValue(startDate+"至"+endDate+sheet.getSheetName());
//        cell.setCellStyle(cellStyle);
//        for(int i = 1;i<=30;i++){
//            Cell cellTemp = row.createCell(i);
//            cellTemp.setCellValue("");
//            cellTemp.setCellStyle(cellStyle);
//        }
//    }
//
//    //创建内容区
//    public void createContentRow(Sheet sheet,String [] titles,String [] content){
//        Row row = sheet.createRow(1);
//        row.setHeight(statisticalCommonExportUtil.getRowHeight());
//        for(int i =0;i<titles.length;i++){
//            Cell cell = row.createCell(i);
//            if(i==titles.length-1){
//                cell.setCellStyle(statisticalCommonExportUtil.getGoldCellStyle());
//            }else{
//                cell.setCellStyle(statisticalCommonExportUtil.getGreenCellStyle());
//            }
//            cell.setCellValue(titles[i]);
//        }
//        Row rowContent = sheet.createRow(2);
//        rowContent.setHeight(statisticalCommonExportUtil.getRowHeight());
//        for(int i =0;i<content.length;i++){
//            Cell cell = rowContent.createCell(i);
//            cell.setCellStyle(statisticalCommonExportUtil.getGenterateCellStyle());
//            cell.setCellValue(content[i]);
//        }
//    }
//
//    private void sheetManagerMerged(Sheet sheet){
//        CellRangeAddress region = new CellRangeAddress(0, 0, 0, 30);
//        sheet.addMergedRegion(region);
//        CellRangeAddress regionTitle = new CellRangeAddress(1,2,0,0);
//        sheet.addMergedRegion(regionTitle);
//    }
//
//}
